import java.io.*;


public class JRate{
    RatingSystem RS;
    SpielerPool SP;

    public JRate(){

        while( true ){
            //ab hier wird ein Pool ausgewhlt.
            boolean andererPool = false;    //man kann auch einen anderen Pool bearbeiten
            BufferedReader din = new BufferedReader( new InputStreamReader(System.in));     
            String antwort = new String();

            System.out.println();
            System.out.print( "Wie heisst der Pool, der bearbeitet/erzeugt werden soll?\n[RETURN = Liste, e = Ausgang]\n: " );
            try{
                antwort = din.readLine();
            }catch( IOException e ){
                System.out.println( "\nFehler in der Eingabe. Bitte weiederholen.\n" );
                andererPool = true;
            }

            if( antwort.length() == 0 ){                
                String list = getPoolListText();
                if( list.length() > 0 ){
                    System.out.println( "\nFolgende Pools bestehen bereits:");                
                    System.out.println( list );                
                }
                andererPool = true;
            }else if( antwort.equals( "e" )){
                // programm wird beendet.
                System.exit(0);
            }

            // andererPool ist hier gleichbedeutend mit "kein Fehler aufgetreten" also kann dann das RatingSystem initialisiert werden.
            if( !andererPool ){
                RS = new RatingSystem( antwort );
                SP = RS.getSpielerPool();
                System.out.println();
            }

            //
            // hier beginnt die Bearbeitung des ausgewhlten Pools
            //            
            while( !andererPool ){
                printHauptMenu();
                try{
                    antwort = din.readLine();
                }catch( IOException e ){}

                if( antwort.equals( "1" )){  
                    // liste der Spieler: name rating
                    System.out.println();               
                    System.out.println();
                    System.out.println( "Folgende Spieler sind in diesem Pool:\n");
                    System.out.print( SP.listSpieler() );
                    System.out.println();                    
                }else if( antwort.equals( "2" )){  
                    // das ergebnis einer partie soll eingegeben werden
                    rate();
                }else if( antwort.equals( "3" )){ 
                    // das rating eines spielers soll ausgegeben werden
                    System.out.println();
                    System.out.print( "Wie heisst der Spieler? " );
                    try{
                        antwort = din.readLine();
                    }catch( IOException e ){}

                    if( antwort.length() == 0 ){
                        System.out.println();
                    }else{
                        Spieler spielerX = SP.getSpieler( antwort );
                        if( spielerX != null ){
                            System.out.println();
                            System.out.println( "Das Rating von " + antwort +" ist: " + spielerX.getRatingText());
                            System.out.println( "...");
                            System.out.println( "Die Tendenzen sind:");
                            System.out.println( spielerX.getTendenzen());
                        }else{
                            System.out.println( "Dieser Spieler existiert nicht im System.");
                        }
                        System.out.println();
                        System.out.println();
                    }
                }else if( antwort.equals( "4" )){  
                    // ein spieler soll gelscht werden
                    System.out.println();
                    System.out.print( "Wie heisst der Spieler, der aus dem Pool ENTFERNT werden soll? " );
                    try{
                        antwort = din.readLine();
                    }catch( IOException e ){}
                    if( antwort.length() == 0 ){
                        System.out.println();
                    }else{
                        if( SP.getSpieler( antwort ) != null ){                    
                            SP.lscheSpieler( antwort );
                        }else{
                            System.out.println( "Dieser Spieler existiert nicht im System.");
                        }
                        System.out.println();
                        System.out.println();
                    }
                }else if( antwort.equals( "5" )){
                    // eine anderer Pool soll bearbeitet werden.
                    System.out.println();
                    System.out.println( "Speichere Pool...");
                    SP.save();
                    System.out.println( "Verlasse diesen Pool...");

                    andererPool = true;
                    System.out.println();

                }else if( antwort.equals( "e" )){ 
                    // das programm wird beendet
                    SP.save();
                    System.exit( 0 );
                }
            }
        }
    }


    public static void main( String[] args ){
        JRate jr = new JRate();
    }

    // nimmt das Ergebnis eines Spiels entgegen und berechnet nachher die neuen Ratings
    protected void rate(){
        BufferedReader din = new BufferedReader( new InputStreamReader(System.in));     

        System.out.println();
        System.out.print( "Wie lautet der Name des Spielers, der Schwarz gespielt hat? " );
        String schwarz = new String();
        try{
            schwarz = din.readLine();
        }catch( IOException e ){}

        if( schwarz.length() == 0 ){
            System.out.println();
            return;
        }

        System.out.print( "Der Name von Weiss? " );
        String weiss = new String();
        try{
            weiss = din.readLine();
        }catch( IOException e ){}

        if( weiss.length() == 0 ){
            System.out.println();
            return;
        }

        System.out.print( "Wie gross war das Handicap [RETURN = 0]? " );
        String handi = new String();
        try{
            handi = din.readLine();
        }catch( IOException e ){}
        if( handi.length() == 0 ){
            handi = "0";
        }

        System.out.print( "Wer hat gewonnen ((s)chwarz, (w)eiss oder (n)iemand)? " );
        String ergebnis = new String();
        try{
            ergebnis = din.readLine().toLowerCase();
        }catch( IOException e ){}

        int p;
        if( ergebnis.equals( "s" )){
            p = -1;
        }else if( ergebnis.equals( "w" )){
            p = 1;
        }else{
            p = 0;
        }

        System.out.print( "\tEvtl. noch Abbruch [RETURN fuer weiter]? ");
        String cont = new String();
        try{
            cont = din.readLine();
        }catch( IOException e ){}

        System.out.println("");

        if( cont.length() > 0 ){
            //Abbruch
        }else{
            int handicap = 0;
           
            boolean fehler = false;
            try{
                handicap = Integer.parseInt( handi );
            }catch( NumberFormatException ev ){
                System.out.println( "Fehler: Das Handicap wurde falsch angegeben.");
                fehler = true;
            }

            if( !fehler ){
                System.out.println( );
                // die Berechnung wird zweimal ausgefhrt. mit vertauschten Rollen
                RS.berechneRating( schwarz, weiss, p, handicap );
               
                System.out.println( );
            }
        }
    }

    protected void printHauptMenu(){
        System.out.println();
        System.out.println( "Bitte waehle aus folgenden Moeglichkeiten:" );
        System.out.println( "---");
        System.out.println( "(1) Liste der gerankten Personen" );
        System.out.println( "(2) Eingabe eines Ergebnisses" );
        System.out.println( "(3) Abfrage des Ratings eines Spielers und die Tendenzen" );
        System.out.println( "(4) Entfernen eines Spielers aus dem System" );
        System.out.println( "(5) Wechsle SpielerPool" );
        System.out.println( "(e) Ausgang" );
        System.out.println();
        System.out.print( ": " );
    }

    protected String getPoolListText(){
        String liste = new String();

        String[] dateien = (new File( System.getProperty( "user.dir"))).list( 
            new FilenameFilter(){
                public boolean accept( File dir, String name ){
                    return name.endsWith( ".data" );
                }
        });

        // die Pools ohne die Endung .data werden in die Liste bernommen
        for( int i = 0; i < dateien.length; i++ ){
            liste = liste + "\t" + dateien[ i ].substring( 0, dateien[ i ].indexOf( ".data" )) + "\n";
        }

        return liste;
    }
}
