import java.io.*;


public class RatingSystem{
    SpielerPool Spool;

    public static final int GEWINNT       =  1;
    public static final int VERLIERT      = -1;
    public static final int UNENTSCHIEDEN =  0;

    public RatingSystem( String poolname ){
        // ldt einen Spielerpool. der kann entweder bereits bestehen oder muss erzeugt werden.
        Spool = new SpielerPool( poolname );
    }

    public SpielerPool getSpielerPool(){
        return Spool;
    }

    // diese Funktion ruft dann berechneNeuesRating zweimal auf, damit fr beide Spieler die Berechnungen vorgenommen werden.
    // zuvor wird getestet, welcher spieler bereits im pool ist und welcher nicht. dementsprechend wird dann berechneNeuesRating aufgerufen.
    public void berechneRating( String name1, String name2, int p, int handicap ){
        BufferedReader din = new BufferedReader( new InputStreamReader(System.in));
        String antwort = new String();

        Spieler spieler1 = Spool.getSpieler( name1 );
        Spieler spieler2 = Spool.getSpieler( name2 );
        if( spieler1 == null && spieler2 == null ){
            printBothNotRatedMessage();
        }else if( !(spieler1 == null) && !(spieler2 == null) ){            
            Spieler spieler1_clone = (Spieler)spieler1.clone();

            // berechne rating fr spieler1
            berechneNeuesRating( spieler1, spieler2, p, handicap );
            // berechne rating fr spieler2, verwende die sicherheitskopie von spieler1, damit die werte nicht verflscht werden.
            berechneNeuesRating( spieler2, spieler1_clone, p * (-1), handicap * (-1));
            Spool.replaceWithSpieler( spieler1_clone );
        }else if( !(spieler2 == null) ){          
            // ein nicht vorhandener spieler wird automatisch eingefgt:
            Spool.addSpieler( name1 );
            spieler1 = Spool.getSpieler( name1 );
            // plus oder minus?
            // beachte auch die nchsten if-klausel!!
            // es scheint so zu stimmen!
            spieler1.setNeuesRating( spieler2.getRating() + handicap );
                            
            berechneNeuesRating( spieler1, spieler2, p, handicap );
        }else if( !(spieler1 == null) ){            
            // ein nicht vorhandener spieler wird automatisch eingefgt:
            Spool.addSpieler( name2 );
            spieler2 = Spool.getSpieler( name2 );
            spieler2.setNeuesRating( spieler1.getRating() - handicap );              

            berechneNeuesRating( spieler2, spieler1, p * (-1), handicap * (-1));
        }
    }

    // aus sicht von Spieler name1
    protected void berechneNeuesRating( Spieler spieler1, Spieler spieler2, int p, int handicap ){                
        
        // wenn mehr als 3 Steine Vorgabe gegeben wurden, soll das Spiel nicht zhlen.
        int max_Handicap = 9;
        if( Math.abs( handicap ) > max_Handicap ){
            System.out.println( "Das Handicap war zu gross. Dieses Spiel wird nicht gewertet.\n" );         
        }else{
            BufferedReader din = new BufferedReader( new InputStreamReader(System.in));
            String antwort = new String();


            // **************************************************** //
            //                                                      //
            //   Hier beginnt die Implementierung des Algorithmus   //
            //                                                      //
            // **************************************************** //


            // Schritt 1
            //
            int Ralt = spieler1.getRating();
            int Rgeg = spieler2.getRating() - handicap;    // oder +? was heisst "schlechter"? -> Schritt 1.

            //
            // Schritte 2+3
            //
            int temp1 = Ralt + Rgeg;
            int temp2 = Math.abs( Ralt - Rgeg );
            int neuesS1 = (temp1 / 2) + p * ((temp2 / 2) + 1);

            // setS1() rutscht die Eintrge im Tendenzvektor um eins nach rechts und ersetzt das erste Element [0] mit neuesS1
            spieler1.setS1( neuesS1 );

            //
            // Schritt 4
            //
            // das Runden auf zwei Nachkommastellen ist ein bisschen trickreich, geht`s einfacher? KORREKT?
            // und vor allem: Was bringts? -> In Schritt 5 werden die Nachkommastellen sowieso wieder abgeschnitten.
            int t5  = (int)(spieler1.getT( 5 )  * 100);
            int t15 = (int)(spieler1.getT( 15 ) * 100);
            int t30 = (int)(spieler1.getT( 30 ) * 100);

            float T5  = ((float)t5)  / 100;
            float T15 = ((float)t15) / 100;
            float T30 = ((float)t30) / 100;
            // so, jetzt mssten die Ti auf zwei Nachkommastellen gerundet sein.

            //
            // Schritt 5
            //
            // was bringt es, das Ergebnis von Schritt 4 auf zwei Nachkommastellen zu runden?
            // ist es besser, hier den Rundungsfehler zu machen, als oben?
            int H1 = (int)(Ralt - T5)  * p;
            int H2 = (int)(Ralt - T15) * p;
            int H3 = (int)(Ralt - T30) * p;

            
            //
            // Schritt 6
            //
            int H1_ = sgn(H1);
            int H2_ = sgn(H2);
            int H3_ = sgn(H3);

            //
            // Schritt 7
            //
            H1 = sgn(1+2*H1_);
            H2 = sgn(1+2*H2_);
            H3 = sgn(1+2*H3_);

            //
            // Schritt 8
            //
            int H4 = H1 + H2 + H3;

            //
            // Schritt 9
            //
            int H5 = sgn( H4 );

            //
            // Schritt 10
            //
            int H6 = (H5 - 1)/2;

            //
            // Schritt 11
            //
            int Rneu = Ralt - (p * H6);

            // *********** //
            //    Ende     //
            // *********** //

            // hier wird das neue Rating von Spieler1 gesetzt.
            spieler1.setNeuesRating( Rneu );
        }

    }



    protected int sgn( int h ){
        if( h == 0 ){
            return 0;
        }else if( h < 0 ){
            return -1;
        }else{
            return 1;
        }
    }
    protected void printBothNotRatedMessage(){
        System.out.println( "Beide Spieler befinden sich noch nicht im System." );
        System.out.println( "Da beide NR sind, werden sie auch nicht ins System aufgenommen." );
        System.out.println( "Sie muessen erst gegen einen Spieler mit Rating spielen.\n" );
    }

    protected void debug( String msg ){
        System.out.println( msg );
    }

}
