import java.util.*;
import java.io.*;



class Spieler
implements Cloneable{
    // der name des Spielers im Pool
    protected String id;
    // sein Rating (Ralt)
    // 0 = 1dan, -1 = 2 dan, etc...
    protected int rating;   
    protected int[] tendenzvektor;
    // Die Anzahl von absolvierten Spielen.
    // bei einem provisorischen Rating ist index < 30, ansonsten index == 30
    protected int index;

    // dieser Konstruktor wird nur zum Eichen eines Pools verwendet.
    // dabei wird der gesamte Tendenzvektor mit dem Rating initialisiert.
    // das Rating ist dann nicht mehr provisorisch.
    public Spieler( String id, int rating ){
        this.id = id;
        this.rating = rating;

        tendenzvektor = new int[ 30 ];
        index = 30;

        for( int i = 0; i < 30; i++ ){
            tendenzvektor[ i ] = rating;
        }     
    }

    // dieser wird beim Hinzufgen eines neuen Spielers verwendet.
    public Spieler( String id ){
        this.id = id;
        index = 0;
        tendenzvektor = new int[ 30 ];
        rating = 0;
    }

    // und dieser beim Laden eines Spielers aus der Pool-Datei.
    // dabei ist id der Name des Spielers im Pool und
    // werte ist ein String mit Kommata, der erste Wert ist das Rating, alle Werte danach gehren in den Tendenzvektor
    public Spieler( String id, String werte ){
        this.id = id;
        StringTokenizer st = new StringTokenizer(werte.replace( ',', ' ' ));
        tendenzvektor = new int[ 30 ];

        if( st.countTokens() > 0 ){   
            //der Spieler hat also schon Eintrge
            // der erste Eintrag ist das Rating
            try{
                rating = Integer.parseInt( (String) st.nextToken() );
            }catch( NumberFormatException e ){
                debug( "Fehler: rank: parseInt." );
            }

            // alle anderen Eintrge sind die absolvierten Spiele
            index = 0;
            while( st.hasMoreTokens() ){
                try{
                    tendenzvektor[ index ] = Integer.parseInt( (String) st.nextToken() );
                    index ++;
                }catch( NumberFormatException e ){
                    //sicher ist sicher
                    debug("Fehler: tendenzvektor: " + (index - 1));
                }
            }
            //index ist jetzt die ober Schranke fr "vernnftige" Tendenzen (sprich Anzahl der absolvierten Spiele), denn es wurden noch nicht mehr Spiele gespielt.            
        }    
    }

    // fgt das neue S1 ein, das neue erste Element des Tendenzvektors.
    // zuvor werden die Elemente des Vektors nach rechts geschoben, also lter gemacht.
    // das 30. (letzte) Element fllt dabei aus dem Vektor.
    public void setS1( int S1 ){
        // die alten Si werden nach rechts gerutscht. dabei wird bei s29 angefangen, das s30 berschreibt.     
        for( int i = tendenzvektor.length - 2; i >= 0; i-- ){
            tendenzvektor[ i + 1 ] = tendenzvektor[ i ];    
        }

        // an die erste Stelle kommt das neue S1
        tendenzvektor[ 0 ] = S1;
        if( index < 30 ){
            //eigentlich ist dieses if nicht wirklich ntig.
            index++;
        }        
    }

    // mit dieser Methode wird am Ende von RatingSystem.berechneNeuesRating() das neue Rating dem Spieler zugewiesen.
    public void setNeuesRating( int neuesRating ){
        rating = neuesRating;
    }

    // liefert den Namen des Spielers
    public String getID(){
        return id;
    }

    // liefert den Tendenzvektor als String mit Komma zwischen den einzelnden Tendenzen.
    // wird nur in JRate zur Ausgabe verwendet.
    public String getTendenzen(){
        String wert = new String();
        
        for( int i = 0; i < index; i++ ){
            wert = wert + tendenzvektor[ i ] + ",";
        }
        
        return wert;
    }

    // hngt vor dem Ergebnis von getTendenzen() noch das Rating.
    // das Ergebnis dieser Methode wird in die .data-Dateien hinter den Spielernamen geschrieben.
    public String getWerte(){
        String wert = new String();
        wert = rating + "," + getTendenzen();

        return wert;
    }    

    // liefert das Rating
    public int getRating(){
        return rating;
    }

    // liefert das Rating mit dan/kyu und provisorisch/fest Unterscheidung.
    // schaut dann aus wie auf einem Go-Server (mit * hinter festen Ratings)
    // wird nur in JRate zur Ausgabe verwendet.
    public String getRatingText(){        
        String R = rating <= 0 ? ((rating * (-1) +1)+"d") : rating + "k";
        R = R + ( isProvisorisch() ? "" : "*");

        return R;
    }

    // liefert Tendenzen. hier mit parametrisierter oberer Grenze.
    // liefert in RatingSystem.berchneNeuesRating() T5, T15 und T30
    // bei einem Spieler, der noch gar keine Tendenzen hat ( i==0 ), wird sein Rating zurckgegeben.
    // fr dieses Rating gilt Rating = Rgeg.
    //
    // mir ist keine bessere Lsung zur Verhinderung von "Division durch Null" eingefallen
    public float getT( int obereGrenze ){
        int summe = 0;

        int i = 0;
        while( i < obereGrenze && i < index ){
            summe = summe + tendenzvektor[ i ];
            i++;
        }

        if( i > 0 ){
            return summe / i;
        }else{
            return rating;       // ist die Frage, ob das passt?
        }
    }

    // liefert true oder false zurck, je nachdem, ob der Spieler noch provisorisch gerated ist oder nicht.
    public boolean isProvisorisch(){
        return index < 30;
    }

    // schaut, ob der Spieler NotRated ist.
    // brauch ich das berhaupt?
    public boolean isNR(){
        return index == 0;
    }

    protected Object clone(){        
        return new Spieler( this.getID(), this.getWerte() );
    }

    // for bug-tracking
    protected void debug( String message ){
        System.out.println( message );
    }


}
