import java.util.*;
import java.io.*;


public class SpielerPool
extends Properties{
    // der Name der .data-Datei, die diesen Pool beinhaltet.
    protected String poolname;
    // der pool-Vector enthlt die Spieler-Objekte dieses Pools
    protected Vector pool;
    

    // der Konstruktor ldt aus der vorhandenen .data-Datei die Spielerdaten und erzeugt Spieler-Objekte.
    // ist die Datei noch nicht vorhanden, wird eine Neue erzeugt.
    // ist eine vorhandene .data-Datei noch leer, so wird versucht, sie zu eichen.
    // wird eine leere .data-Datei nicht geeicht, nimmt sie auch keine Werte auf. 
    // Das hngt damit zusammen, dass es dann keinen Spieler gibt, der geratet ist, also alle NR sind.
    public SpielerPool( String dateiname ){
        poolname = dateiname + ".data";
        pool = new Vector();

        try{
            load( new FileInputStream( poolname ));
        }catch( IOException e ){       
            debug( "\n\nNeue Pool-Datei wird erzeugt." );
            try{
                store( new FileOutputStream( poolname ), "JRate SpielerPool" );
            }catch( IOException ex ){
                debug( "Fehler beim Erzeugen der neuen Pool-Datei!" );
            }
        }

        Enumeration enum = propertyNames();
        while( enum.hasMoreElements()){
            String id = (String) enum.nextElement();
            String werte = getProperty( id );
         
            pool.add( new Spieler( id, werte ));
        }

        if( pool.size() == 0 ){
            // es ist noch kein Spieler im Pool vorhanden, also muss der Pool noch geeicht werden.
            eichePool();
        }
    }

    // fgt einen Spieler in den Pool ein.
    public void addSpieler( String id ){        
        pool.add( new Spieler( id ));
    }

    // lscht einen Spieler aus dem Pool
    public void lscheSpieler( String id ){
        remove( id );
        pool.remove( getSpieler( id ));
    }

    // mit dieser funktion wird ein spieler durch seinen clone ersetzt.
    // wird bei der berechnung des Ratings in RS.berechneRating() verwendet.
    public void replaceWithSpieler( Spieler spieler ){
        lscheSpieler( spieler.getID() );
        
        pool.add( new Spieler( spieler.getID(), spieler.getWerte() ));        
    }

    // liefert ein Objekt vom Typ Spieler, das anhand des Namens identifiziert wird, zurck
    public Spieler getSpieler( String id ){
        Enumeration enum = pool.elements();
        Spieler sp = null;

        Spieler temp = null;
        
        while( enum.hasMoreElements() && sp == null ){
            temp = (Spieler) enum.nextElement();
            if( temp.getID().equals( id ) ){                
                sp = temp;
            }
        }

        return sp;
    }

    // liefert einen String mit der Liste der im Pool enthaltenen Spielernamen samt Rating
    public String listSpieler(){
        Enumeration enum = pool.elements();
        String liste = new String();

        while( enum.hasMoreElements() ){
            Spieler sp = (Spieler) enum.nextElement();
            liste = liste + sp.getID() + "\n\t" + sp.getRatingText() + "\n";            
        }

        return liste;
    }

    // eicht den Pool, d.h. fr den ersten Spieler im Pool wird der Tendenzvektor mit dem angegebenen Rating initialisiert werden.
    // der pool kann mit beliebig vielen Spieler geeicht werden.
    protected void eichePool(){
        System.out.println( "\nDieser Spieler-Pool ist noch nicht geeicht.");
        System.out.println( "Zum Eichen eines Pools muessen Rang und Name \nmindestens eines Spieler angegeben werden.");
        System.out.println( "Moechtest du jetzt diesen Pool (" + poolname +") eichen?");
        System.out.print( "\tj(a)[RETURN] oder n(ein)?");

        BufferedReader din = new BufferedReader( new InputStreamReader(System.in));

        String antwort = new String();
        try{
            antwort = din.readLine();
        }catch( IOException r ){}

        System.out.println( );

        while( !(antwort.toLowerCase().startsWith( "n" )) ){
            System.out.print( "Gib jetzt bitte den Namen des Spielers ein: " );
            String name = new String();
            try{
                name = din.readLine();
            }catch( IOException r ){}

            if( name.length() == 0 ){
                // ein einfaches Return wird als Abbruch gewertet.
                return;
            }
            
            int zahl = getRankAsNumber();
            if( zahl == 3333 ){   // "Fehlercode"  => Abbruch
                return;
            }

            pool.add( new Spieler( name, zahl ));
            System.out.println( );

            System.out.println( "Moechtest du diesen Pool mit einem weiteren Spieler eichen?");
            System.out.print( "\tj(a)[RETURN] oder n(ein)?");

            try{
                antwort = din.readLine();
            }catch( IOException r ){}

            System.out.println( );
        }
    }

    protected int getRankAsNumber(){
        BufferedReader din = new BufferedReader( new InputStreamReader(System.in));
        int indexD = 0;
        int indexK = 0;
        String rank = new String();
        while( indexD == indexK ){
            System.out.print( "Was ist sein Rang ( z.B. 10k oder 3d )? " );
            try{
                rank = din.readLine().toLowerCase();
            }catch( IOException r ){}

            if( rank.length() == 0 ){
                // ein einfaches Return wird als Abbruch gewertet.
                return 3333; // "Fehlercode"
            }
          
            indexD = rank.indexOf( "d" );
            indexK = rank.indexOf( "k" );

            if( indexD < 0 ){
                indexD = 1000;
            }else if( indexK < 0 ){
                indexK = 1000;
            }        

            // wenn weder k noch d vorkommt, haben wir ein Problem:
            if( indexK == indexD ){
                System.out.println( "Bitte fge noch 'd' oder 'k' dem Rang hinzu." );
            }
        }

        int index = Math.min( indexD, indexK);

        int zahl = 0;        
        try{
            zahl = Integer.parseInt( rank.substring( 0, index ) );
        }catch( NumberFormatException e ){
            debug( "Fehler beim Parsen des Rangs.");     
            return 3333; // "Fehlercode"
        }

        // wenn ein Dan zum Eichen verwenden werden soll, dann muss das Rating noch umgerechnet werden.
        if( indexD < 1000 ){             
            zahl = zahl * -1;
            zahl = zahl + 1;    // 1dan -> 0; 2d -> -1
        }

        return zahl;
    }

    // speichert diesen Pool in eine .data-Datei
    public void save(){
        Enumeration enum = pool.elements();

        while( enum.hasMoreElements() ){
            Spieler sp = (Spieler) enum.nextElement();
            String id = sp.getID();
            String werte = sp.getWerte();

            //sicherheitshalber wird der spieler erstmal entfernt,
            // bevor er aus dem Vector wieder eingefgt wird.
            remove( id );            
            setProperty( id, werte );
        }

        try{
            store( new FileOutputStream( poolname ), "JRate SpielerPool" );
        }catch( IOException e ){
            debug( "Fehler beim Speichern der Pool-Daten!" );
        }
    }

    // for bug-tracking
    protected void debug( String message ){
        System.out.println( message );
    }


}
