/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.auxiliary.shortcuts;

import de.gungfu.auxiliary.shortcuts.ShortcutRegistry;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;

public class ShortcutListener
implements MenuKeyListener {
    private ShortcutRegistry _registry = Preferences.getPreferences().getShortcutRegistry();

    public void menuKeyPressed(MenuKeyEvent e) {
        this._registry.enterShortcutIntoRegistryBuffer(KeyStroke.getKeyStrokeForEvent(e));
        e.consume();
    }

    public void menuKeyReleased(MenuKeyEvent e) {
        if (!Boolean.valueOf(Preferences.getPreferences().getProperty(20)).booleanValue() || e.isConsumed()) {
            return;
        }
        MenuElement[] me = e.getMenuSelectionManager().getSelectedPath();
        JMenuItem item = (JMenuItem)me[me.length - 1];
        JMenuItem oldItem = this._registry.enterShortcutIntoRegistry(item, KeyStroke.getKeyStrokeForEvent(e));
        if (oldItem != null) {
            oldItem.repaint();
        }
        item.repaint();
        this.relayoutMenu((JPopupMenu)item.getParent());
        e.consume();
    }

    public void menuKeyTyped(MenuKeyEvent e) {
    }

    private void relayoutMenu(JPopupMenu menu) {
        int i = 0;
        while (i < menu.getComponentCount()) {
            menu.getComponent(i).invalidate();
            ++i;
        }
        menu.invalidate();
        menu.pack();
    }
}

