/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.auxiliary.shortcuts;

import de.gungfu.auxiliary.shortcuts.KeyStrokeConverter;
import de.gungfu.auxiliary.shortcuts.StrokesAndTextsMapper;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ShortcutRegistry
extends Hashtable {
    public static final String SHORTCUT_IDENTIFIER = "shortcut:";
    public static final char WHITE_SPACE_REPLACEMENT = '-';
    private boolean _shortcutChanged = false;
    private KeyStroke _lastKeyStroke;
    private StrokesAndTextsMapper _textsAndStrokes = new StrokesAndTextsMapper();

    public static ShortcutRegistry loadShortcutsFromPreferences(Hashtable preferences) {
        ShortcutRegistry newReg = new ShortcutRegistry();
        Enumeration prefs = preferences.keys();
        while (prefs.hasMoreElements()) {
            String element = (String)prefs.nextElement();
            if (!element.startsWith(SHORTCUT_IDENTIFIER)) continue;
            newReg._textsAndStrokes.put((String)preferences.get(element), ShortcutRegistry.generateKeyStrokeFromPreferenceEntry(element));
        }
        return newReg;
    }

    public Enumeration getEnumerationOverAllShortcuts() {
        return this._textsAndStrokes.getShortcuts();
    }

    public String getText(KeyStroke stroke) {
        return this._textsAndStrokes.getText(stroke);
    }

    public Object put(KeyStroke key, JMenuItem value) {
        this._textsAndStrokes.put(value.getText(), key);
        return super.put(key, value);
    }

    public Object put(Object key, Object value) {
        System.out.println("Using wrong method! -> put");
        return null;
    }

    private static KeyStroke generateKeyStrokeFromPreferenceEntry(String textualDescription) {
        String descript = textualDescription.substring(SHORTCUT_IDENTIFIER.length());
        descript = descript.replace('-', ' ');
        return KeyStroke.getKeyStroke(descript);
    }

    public KeyStroke getKeyStrokeByMenuText(String text) {
        return this._textsAndStrokes.getStroke(text);
    }

    public JMenuItem enterShortcutIntoRegistry(JMenuItem item, KeyStroke newKeyStroke) {
        JMenuItem oldItem;
        Preferences.getPreferences().setPropertyShortcut(ShortcutRegistry.generatePreferenceEntryFromKeyStroke(this._lastKeyStroke), item.getText());
        if (this.get(this._lastKeyStroke) != null && this.get(this._lastKeyStroke).equals(item)) {
            return this.removeShortcutFromItemAndRegistry(item);
        }
        if (this._textsAndStrokes.getStroke(item.getText()) != null && !this._textsAndStrokes.getStroke(item.getText()).equals(newKeyStroke)) {
            this.removeShortcutFromItemAndRegistry(item);
        }
        if ((oldItem = (JMenuItem)this.get(this._lastKeyStroke)) != null) {
            this.removeShortcutFromItemAndRegistry(oldItem);
        }
        this.put(this._lastKeyStroke, item);
        item.setAccelerator(this._lastKeyStroke);
        return oldItem;
    }

    public void enterShortcutIntoRegistryBuffer(KeyStroke keys) {
        this._lastKeyStroke = keys;
    }

    private JMenuItem removeShortcutFromItemAndRegistry(JMenuItem oldItem) {
        oldItem.setAccelerator(null);
        KeyStroke oldStroke = this._textsAndStrokes.remove(oldItem.getText());
        this.remove(oldStroke);
        ((Hashtable)Preferences.getPreferences()).remove(ShortcutRegistry.generatePreferenceEntryFromKeyStroke(oldStroke));
        return oldItem;
    }

    public static String generatePreferenceEntryFromKeyStroke(KeyStroke key) {
        return SHORTCUT_IDENTIFIER + KeyStrokeConverter.keyStroke2String(key).replace(' ', '-');
    }
}

