/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenApplicationHandler;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJQuitHandler;
import de.gungfu.jacoto.auxiliary.LocationCalculator;
import de.gungfu.jacoto.auxiliary.StatisticsViewer;
import de.gungfu.jacoto.auxiliary.TableSearcher;
import de.gungfu.jacoto.auxiliary.ThreadedFITLoader;
import de.gungfu.jacoto.gui.auxiliary.MessageDialogs;
import de.gungfu.jacoto.gui.auxiliary.SplashScreen;
import de.gungfu.jacoto.gui.dialog.CommentButtonListener;
import de.gungfu.jacoto.gui.dialog.CommentEditingDialog;
import de.gungfu.jacoto.gui.dialog.CommentEditor;
import de.gungfu.jacoto.gui.dialog.CommentTextFieldListener;
import de.gungfu.jacoto.gui.dialog.SelectablePropertiesDialog;
import de.gungfu.jacoto.gui.dialog.ViewerCommandDialog;
import de.gungfu.jacoto.gui.dialog.htmlinfo.FileAlreadyContainedInTableException;
import de.gungfu.jacoto.gui.dialog.htmlinfo.HtmlInfoDialog;
import de.gungfu.jacoto.gui.dnd.FileDrop;
import de.gungfu.jacoto.gui.menu.MainMenu;
import de.gungfu.jacoto.gui.menu.TablePopupListener;
import de.gungfu.jacoto.gui.playlist.Jukebox;
import de.gungfu.jacoto.gui.playlist.PlaylistCellRenderer;
import de.gungfu.jacoto.gui.playlist.PlaylistModel;
import de.gungfu.jacoto.gui.playlist.PlaylistPopupActionListener;
import de.gungfu.jacoto.gui.playlist.PlaylistPopupListener;
import de.gungfu.jacoto.gui.playlist.PlaylistSelectionListener;
import de.gungfu.jacoto.gui.table.CommentImageHeaderCellRenderer;
import de.gungfu.jacoto.gui.table.JacotoTableCellRenderer;
import de.gungfu.jacoto.gui.table.StandardHeaderCellRenderer;
import de.gungfu.jacoto.gui.table.StoneImageHeaderCellRenderer;
import de.gungfu.jacoto.listener.FileDropListener;
import de.gungfu.jacoto.listener.JacotoActionListener;
import de.gungfu.jacoto.listener.TableHeaderListener;
import de.gungfu.jacoto.logic.FileInfoTableModel;
import de.gungfu.jacoto.logic.auxiliary.PointJ;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import de.gungfu.jacoto.logic.filter.JacFilter;
import de.gungfu.jacoto.logic.filter.SGFnXMLFilter;
import de.gungfu.jacoto.logic.filter.TxtFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class Jacoto
extends MouseAdapter
implements TableModelListener,
ItemListener,
LocationCalculator,
Jukebox,
MRJAboutHandler,
MRJOpenApplicationHandler,
MRJOpenDocumentHandler,
MRJQuitHandler {
    private final String VERSION = "v1.2.6m";
    private final String RELEASE_DATE = "September 23rd 2002";
    private int _dummyIndex = 0;
    private Point _position;
    private Dimension _size;
    private MessageDialogs _messages;
    private TableSearcher _tableSearcher;
    private JFrame _frame;
    private JTable _table;
    private JSplitPane _splitPane;
    private FileInfoTableModel _currentlySelectedFIT;
    private JTable _playlist;
    private Hashtable _playlistRegistry;
    private static final double PLAYLIST_REGISTRY_SIZE_FACTOR = 1.5;
    private JScrollPane _scrollPane;
    private TablePopupListener _popupListener;
    private FileDrop _fileDrop;
    private FileDropListener _fdListener;
    private long _whenMouseClicked;
    private boolean _itemListenerActive;
    private String _workingDirTemp;
    private final String STANDARD_TITLE = "Jacoto v1.2.6m      - Collection Tool -      ";
    public static final String DUMMY_FILENAME = "EmptyTable";
    private ActionListener _actionListener;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public void versionDialog() {
        this._messages.message("Jacoto Version v1.2.6m by September 23rd 2002\nCopyright 2002 by Steffen Glueckselig\n\nJacato is software under the GPL.\nThere is absolutely no warranty.\nSee http://www.gnu.org/copyleft/copyleft.html\n\nCONTACT THE AUTHOR:\n\nemail:\njacoto@gungfu.de\n\nwebsite:\nhttp://www.gungfu.de/go/coding/Jacoto/", "About");
    }

    public Jacoto() {
        this(new String[0]);
    }

    public Jacoto(String[] args) {
        System.setErr(System.out);
        if (Boolean.valueOf(Preferences.getPreferences().getProperty(5)).booleanValue()) {
            SplashScreen.splashScreenOn("v1.2.6m", "September 23rd 2002");
        }
        this.initFrameNewWindow();
        this._messages = new MessageDialogs(this._frame);
        this._tableSearcher = new TableSearcher(this);
        this._actionListener = new JacotoActionListener(this, new StatisticsViewer(this));
        this.initContentPanes();
        if (args.length == 1 && args[0].endsWith(".jac") && new File(args[0]).isFile()) {
            this.addExistingFITToPlaylist(args[0]);
        }
        this.initSelectedPlaylistItemForDisplay();
        this.initFrameBeforeDisplay();
        this._fdListener = new FileDropListener(this);
        this._fileDrop = new FileDrop((Component)this._scrollPane, true, (FileDrop.Listener)this._fdListener);
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this);
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)this);
        MRJApplicationUtils.registerOpenApplicationHandler((MRJOpenApplicationHandler)this);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this);
        SplashScreen.splashScreenOff();
        ((Component)this._frame).setVisible(true);
    }

    private void initContentPanes() {
        this._scrollPane = new JScrollPane();
        this._scrollPane.setMinimumSize(new Dimension(200, 0));
        this._scrollPane.setVerticalScrollBarPolicy(22);
        this.initPlaylist();
        this._splitPane = new JSplitPane(1, this._playlist, this._scrollPane);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setDividerLocation(this.parseIntFromProperty(22));
        this._splitPane.setDividerSize(8);
        this._frame.getContentPane().add(this._splitPane);
    }

    private void initPlaylist() {
        this._playlist = new JTable();
        this._playlist.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = Jacoto.class$("java.lang.Object")) : class$java$lang$Object, new PlaylistCellRenderer());
        this._playlist.addMouseListener(new PlaylistPopupListener(new PlaylistPopupActionListener(this)));
        this._playlist.setMinimumSize(new Dimension(100, 0));
        this._playlist.setSelectionMode(0);
        this._playlist.getSelectionModel().addListSelectionListener(new PlaylistSelectionListener(this));
        this._playlist.setShowGrid(false);
        ((DefaultCellEditor)this._playlist.getDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = Jacoto.class$("java.lang.Object")) : class$java$lang$Object)).setClickCountToStart(2);
        this.initAndLoadTablesIntoPlaylist();
    }

    private void initAndLoadTablesIntoPlaylist() {
        this._playlistRegistry = new Hashtable();
        this._playlist.setModel(new PlaylistModel(this));
        this.loadPlaylistEntries();
        String activeTable = Preferences.getPreferences().getProperty(23);
        if (activeTable.length() > 0 && this.getPlaylistModel().containsID(activeTable)) {
            this.selectPlaylistEntryByValue(activeTable);
        } else if (this._playlist.getModel().getRowCount() > 0) {
            this.selectPlaylistEntry(this._playlist, 0);
        } else {
            this.addEmptyFITToPlaylist();
        }
    }

    private void loadPlaylistEntries() {
        Vector adds = Preferences.getPreferences().getProperties(25);
        Vector<ThreadedFITLoader> loading = new Vector<ThreadedFITLoader>();
        Iterator iter = ((AbstractList)adds).iterator();
        while (iter.hasNext()) {
            String filename = (String)iter.next();
            if (new File(filename).isFile()) {
                loading.add(this.addFITToPlaylist(filename));
                continue;
            }
            System.out.println("Jacoto.initAndLoadTablesIntoPlaylist: File \"" + filename + "\" does not exist!");
        }
        this.waitForFITsToLoad(loading);
    }

    private void waitForFITsToLoad(Vector tGroup) {
        Iterator iter = ((AbstractList)tGroup).iterator();
        while (iter.hasNext()) {
            this.waitForFITToLoad((ThreadedFITLoader)iter.next());
        }
    }

    private void waitForFITToLoad(ThreadedFITLoader loader) {
        while (loader != null && loader.isLoading()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void addEmptyFITToPlaylist() {
        while (!this.getPlaylistModel().addElement(DUMMY_FILENAME + this._dummyIndex)) {
            ++this._dummyIndex;
        }
        String filename = DUMMY_FILENAME + this._dummyIndex;
        FileInfoTableModel newFit = new FileInfoTableModel();
        newFit.addTableModelListener(this, true);
        this._playlistRegistry.put(filename, newFit);
        this.setCurrentlySelectedFIT(filename);
        this.selectPlaylistEntryByValue(PlaylistModel.extractUserfriendlyNameFromFilename(filename));
    }

    public void removeFITFromPlaylist() {
        this.askSaveTable();
        String filename = this.getPlaylistModel().getCorrespondingFilenameByIndex(this._playlist.getSelectedRow());
        this._playlistRegistry.remove(filename);
        this.getPlaylistModel().removeByFilename(filename);
        if (this.getPlaylistModel().getSize() > 0) {
            this.selectPlaylistEntry(this._playlist, 0);
        } else {
            this.addEmptyFITToPlaylist();
        }
    }

    public void renameFITInPlaylist(int row, String newName) {
        String filename = this.getPlaylistModel().getCorrespondingFilenameByIndex(row);
        if (filename.startsWith(DUMMY_FILENAME)) {
            this.saveAs(newName);
        }
    }

    public void renameFileContainingFIT() {
        System.out.println("rename file in Jacoto.renameFileContainingFIT()");
    }

    public void addExistingFITToPlaylist() {
        this.waitForFITToLoad(this.addFITToPlaylist());
        this.selectPlaylistEntry(this._playlist, this.getPlaylistModel().getSize() - 1);
    }

    public void addExistingFITToPlaylist(String filename) {
        this.waitForFITToLoad(this.addFITToPlaylist(filename));
        this.selectPlaylistEntry(this._playlist, this.getPlaylistModel().getSize() - 1);
    }

    private void selectPlaylistEntry(JTable playlist, int index) {
        playlist.addRowSelectionInterval(index, index);
        playlist.changeSelection(index, 0, true, true);
    }

    private void selectPlaylistEntryByValue(String value) {
        int index = this.getPlaylistModel().findRowIndexByID(value);
        if (index >= 0) {
            this.selectPlaylistEntry(this._playlist, index);
        } else {
            System.out.println("Error in selectPlaylistEntryByValue: Entry not found");
        }
    }

    public ThreadedFITLoader addFITToPlaylist() {
        return this.addFITToPlaylist(this.openOpenDialog("Open"));
    }

    private ThreadedFITLoader addFITToPlaylist(String filename) {
        return this.addFITToPlaylist(filename, this._playlistRegistry, this._playlist);
    }

    private ThreadedFITLoader addFITToPlaylist(String filename, Hashtable registry, JTable list) {
        if (filename != null) {
            if (new File(filename).isFile()) {
                if (this.getPlaylistModel().addElement(filename)) {
                    ThreadedFITLoader threadLoader = new ThreadedFITLoader(filename, registry, this);
                    threadLoader.start();
                    return threadLoader;
                }
                return null;
            }
            System.out.println("addFITToPlaylist: not a file: " + filename);
            return new ThreadedFITLoader();
        }
        return new ThreadedFITLoader();
    }

    private void initFrameNewWindow() {
        this._table = new JTable();
        this._frame = new JFrame();
        this._frame.setTitle("Jacoto v1.2.6m      - Collection Tool -      ");
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Jacoto.this.close();
            }
        });
        this.initSizeAndLocation();
    }

    private void initSizeAndLocation() {
        Preferences prefs = Preferences.getPreferences();
        int locX = 200;
        int locY = 300;
        this._size = new Dimension(this.parseIntFromProperty(0), this.parseIntFromProperty(1));
        try {
            this._position = new Point(this.parseIntFromProperty(2), this.parseIntFromProperty(3));
        }
        catch (NumberFormatException e) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this._position = new Point((screenSize.width - this._size.width) / 2, (screenSize.height - this._size.height) / 2);
        }
        ((Component)this._frame).setSize(this._size);
        ((Component)this._frame).setLocation(this._position);
    }

    private void initFrameBeforeDisplay() {
        this._frame.setDefaultCloseOperation(0);
        ((Frame)this._frame).setIconImage(Preferences.getPreferences().getImageIcon("FrameIcon").getImage());
        this._frame.setJMenuBar(new MainMenu(this._actionListener, this, this.getColumnNames(), this.getCurrentlySelectedFIT().getSortingFull()));
    }

    private void setCurrentlySelectedFIT(String filename) {
        this._currentlySelectedFIT = (FileInfoTableModel)this._playlistRegistry.get(filename);
    }

    private FileInfoTableModel getCurrentlySelectedFIT() {
        return (FileInfoTableModel)this._playlistRegistry.get(this.getPlaylistModel().getCorrespondingFilenameByIndex(this._playlist.getSelectedRow()));
    }

    private void initSelectedPlaylistItemForDisplay(String filename) {
        this.setCurrentlySelectedFIT(filename);
        this.initSelectedPlaylistItemForDisplay();
    }

    private void initSelectedPlaylistItemForDisplay() {
        this._table.setModel(this.getCurrentlySelectedFIT());
        this._table.setSelectionMode(0);
        this._popupListener = new TablePopupListener(this._actionListener, this.getCurrentlySelectedFIT());
        this._table.addMouseListener(this._popupListener);
        this._table.addMouseListener(this);
        this._table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = Jacoto.class$("java.lang.Object")) : class$java$lang$Object, new JacotoTableCellRenderer(this.getCurrentlySelectedFIT()));
        this._table.setColumnSelectionAllowed(false);
        this.setUpCommentEditor(this._table);
        JTableHeader jth = this._table.getTableHeader();
        jth.addMouseListener(new TableHeaderListener(this));
        this.setUpHeaderRenderer(jth);
        this._scrollPane.setViewportView(this._table);
    }

    private String[] getColumnNames() {
        String[] columnNames = new String[this.getCurrentlySelectedFIT().getColumnCount()];
        int i = 0;
        while (i < columnNames.length) {
            columnNames[i] = this.getCurrentlySelectedFIT().getColumnName(i);
            ++i;
        }
        return columnNames;
    }

    private void setUpHeaderRenderer(JTableHeader jth) {
        TableColumnModel columnModel = jth.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn currentTableColumn = columnModel.getColumn(i);
            String columnIdentifier = (String)currentTableColumn.getIdentifier();
            if (columnIdentifier.indexOf("PlayerBlack") >= 0 || columnIdentifier.indexOf("PlayerWhite") >= 0) {
                currentTableColumn.setHeaderRenderer(new StoneImageHeaderCellRenderer(columnIdentifier, this.getCurrentlySelectedFIT()));
            } else if (columnIdentifier.equals("Comment")) {
                currentTableColumn.setHeaderRenderer(new CommentImageHeaderCellRenderer(columnIdentifier, this.getCurrentlySelectedFIT()));
            } else {
                currentTableColumn.setHeaderRenderer(new StandardHeaderCellRenderer(this.getCurrentlySelectedFIT()));
            }
            ++i;
        }
    }

    private void setUpCommentEditor(JTable table) {
        JButton button = new JButton(""){

            public void setText(String s) {
            }
        };
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        TableCellEditor defaultEditor = table.getDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = Jacoto.class$("java.lang.String")) : class$java$lang$String);
        CommentEditor commentEditor = new CommentEditor(button, defaultEditor, new CommentTextFieldListener(this.getCurrentlySelectedFIT()));
        CommentEditingDialog dialog = new CommentEditingDialog(this._frame);
        table.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = Jacoto.class$("java.lang.String")) : class$java$lang$String, commentEditor);
        CommentButtonListener listener = new CommentButtonListener(this.getCurrentlySelectedFIT(), button, dialog);
        button.addActionListener(listener);
    }

    private boolean askSaveSettingsAndSavePlaylist() {
        Vector selectedProperties = null;
        if (Preferences.getPreferences().hasChangedSinceLastSave()) {
            SelectablePropertiesDialog dialog = new SelectablePropertiesDialog(this._frame, this, "Settings to be saved", Preferences.getPreferences().getThingsChanged(), Preferences.getPreferences().getThingsChangedDefaultSelections());
            Integer selectedValue = dialog.getSelectedButton();
            if (selectedValue == null) {
                return true;
            }
            if (selectedValue == 2) {
                return true;
            }
            if (selectedValue == 0) {
                selectedProperties = dialog.getSelectedProperties();
            } else if (selectedValue == 1) {
                // empty if block
            }
        }
        this.saveSets(selectedProperties);
        return false;
    }

    private void askSaveTables() {
        int selectedIndexTemp = this._playlist.getSelectedRow();
        int i = 0;
        while (i < this.getPlaylistModel().getSize()) {
            this.selectPlaylistEntry(this._playlist, i);
            this.askSaveTable();
            ++i;
        }
        this.selectPlaylistEntry(this._playlist, selectedIndexTemp);
    }

    private boolean askSaveTable() {
        boolean cancel = false;
        JOptionPane pane = null;
        JDialog dialog = null;
        if (!this.getCurrentlySelectedFIT().isSavedSinceLastChange() && this.getCurrentlySelectedFIT().getSize() > 0) {
            pane = new JOptionPane("Table \"" + this.getPlaylistModel().getCorrespondingIDByIndex(this._playlist.getSelectedRow()) + "\" not saved since last change.\nWould you like to save it now?", 2, 0);
            dialog = pane.createDialog(this._frame, "Warning!");
            dialog.show();
            Object selectedValue = pane.getValue();
            if (selectedValue != null) {
                if ((Integer)selectedValue == 0) {
                    this.store();
                } else if ((Integer)selectedValue == 1) {
                    // empty if block
                }
            }
        }
        return cancel;
    }

    public boolean store() {
        if (this.getCurrentlySelectedFIT() == null) {
            System.out.println("Error in method Jacoto.actinPerformed(): No FIT.");
            return false;
        }
        if (this.save()) {
            this._messages.message("Table saved successfully.");
            return true;
        }
        this._messages.message("It was not possible to save table.");
        return false;
    }

    public void close() {
        Preferences prefs = Preferences.getPreferences();
        prefs.setProperty(2, "" + this._frame.getX());
        prefs.setProperty(3, "" + this._frame.getY());
        prefs.setProperty(0, "" + this._frame.getWidth());
        prefs.setProperty(1, "" + this._frame.getHeight());
        prefs.setProperty(22, "" + this._splitPane.getDividerLocation());
        int select = JOptionPane.showConfirmDialog(this._frame, "Sure to exit Jacoto?", "Exit Jacoto...", 0, 3);
        if (select == 1) {
            return;
        }
        this.askSaveTables();
        if (!this.askSaveSettingsAndSavePlaylist()) {
            ((Component)this._frame).setVisible(false);
            this._frame.dispose();
            System.out.println("\nGoodbye!\n");
            System.exit(0);
        }
    }

    private boolean save() {
        if (this.getCurrentlySelectedFIT().getFilename() == null) {
            return this.saveAs("");
        }
        return this.getCurrentlySelectedFIT().save();
    }

    public void storeAs() {
        this.storeAs("");
    }

    public void storeAs(String proposal) {
        if (this.getCurrentlySelectedFIT() == null) {
            System.out.println("Error in method Jacoto.actinPerformed(): No FIT.");
        } else if (this.saveAs(proposal)) {
            this._messages.message("Table saved successfully.");
        } else {
            this._messages.message("It was not possible to save table.");
        }
    }

    private boolean saveAs(String proposal) {
        String location = this.openSaveDialog("Save", proposal);
        while (location != null && this.getPlaylistModel().isContainedAsID(location) && location.indexOf(DUMMY_FILENAME) >= 0) {
            this._messages.message("This handle is already in the list.\nPlease name the file differently.");
            location = this.openSaveDialog("Save", proposal);
        }
        boolean saved = false;
        if (location != null) {
            this.replaceDummyEntryWithRealFilename(location);
            this.getCurrentlySelectedFIT().setFilename(location);
            saved = this.getCurrentlySelectedFIT().save();
            this.getCurrentlySelectedFIT().setWorkingDirectory(this.extractDirectory(location));
        }
        return saved;
    }

    private void replaceDummyEntryWithRealFilename(String filename) {
        String oldID = this.getPlaylistModel().getCorrespondingIDByIndex(this._playlist.getSelectedRow());
        Object fit = this._playlistRegistry.get(oldID);
        this._playlistRegistry.remove(oldID);
        this._playlistRegistry.put(filename, fit);
        this.getPlaylistModel().replace(oldID, filename);
    }

    public void export() {
        if (this.getCurrentlySelectedFIT() == null) {
            System.out.println("Error in method Jacoto.actinPerformed(): No FIT.");
        } else if (this.getCurrentlySelectedFIT().isEmptyTable()) {
            this._messages.message("An empty table will not get exported.");
        } else {
            String location = this.openSaveDialog("Exporting as Textfile", PlaylistModel.extractUserfriendlyNameFromFilename(this.getPlaylistModel().getCorrespondingFilenameByIndex(this._playlist.getSelectedRow())));
            if (location != null) {
                this.getCurrentlySelectedFIT().export(location);
            } else {
                this._messages.message("Please specify file.");
            }
        }
    }

    public void add() {
        String location;
        if (this.getCurrentlySelectedFIT() == null) {
            // empty if block
        }
        if ((location = this.openOpenDialog("Adding SGF-record")) != null && new File(location).isFile()) {
            if (!location.equals(this.getCurrentlySelectedFIT().getWorkingDirectory()) && this.openAskNewWorkingDir(new File(location).getParent(), this.getCurrentlySelectedFIT().getRecordsDirectory().getPath())) {
                this.getCurrentlySelectedFIT().setRecordsDirectory(new File(location).getParent());
            }
            try {
                int in = this.getCurrentlySelectedFIT().add(location);
                if (in == 1) {
                    this._messages.message("One of the SGF-records in the collection has already been in the table.");
                } else if (in > 1) {
                    this._messages.message(in + " of the SGF-records of the collection have already been in the table.");
                } else if (in == -1) {
                    this._messages.message("One record has been added to the table.");
                }
            }
            catch (FileAlreadyContainedInTableException e) {
                this._messages.message("Record already in table.");
            }
        } else {
            this._messages.message("It was not possible to add a file to the table!");
        }
    }

    public void addAll() {
        int number = this.getCurrentlySelectedFIT().addAllFIs();
        this._messages.loadMessage(number);
    }

    public void addAllBelow() {
        int number = this.getCurrentlySelectedFIT().addAllFIsBelow();
        this._messages.loadMessage(number);
    }

    public int addDroppedFile(File aFile) {
        return this.getCurrentlySelectedFIT().addDroppedFile(aFile);
    }

    public void removeSelectedRow() {
        int selectedRow = this._table.getSelectedRow();
        if (!this.getCurrentlySelectedFIT().removeFI(selectedRow)) {
            this._messages.message("Please select row to remove.");
        }
    }

    public void markViewed() {
        int selectedRow = this._table.getSelectedRow();
        this.getCurrentlySelectedFIT().markViewed(selectedRow);
    }

    public void markUnviewed() {
        int selectedRow = this._table.getSelectedRow();
        this.getCurrentlySelectedFIT().markUnviewed(selectedRow);
    }

    public void viewerLocationDialog() {
        String location = this.openOpenDialog("ViewerLocation");
        if (location != null && this.isDirectory(location)) {
            this.getCurrentlySelectedFIT().setViewerLocation(location);
        }
    }

    public void viewerCommandsDialog() {
        Preferences prefs = Preferences.getPreferences();
        String[] cmds = prefs.getCommandsAsArray();
        ViewerCommandDialog vcd = new ViewerCommandDialog((Frame)this._frame, cmds);
        vcd.show(this.getCurrentlySelectedFIT().getViewerCommand());
        if (!vcd.wasCanceled()) {
            String command = vcd.getChoice();
            if (vcd.getRemoved().size() > 0) {
                int i = 0;
                while (i < vcd.getRemoved().size()) {
                    prefs.removeViewerCommand((String)vcd.getRemoved().elementAt(i));
                    ++i;
                }
            }
            if (command != null && !command.equals("")) {
                this.getCurrentlySelectedFIT().setViewerCommand(command);
                if (vcd.isChoiceNew()) {
                    prefs.setProperty(15, command);
                }
                prefs.setCurrentViewerCommand(command);
            } else {
                this._messages.message("There was an error. Please choose a viewerCommand again!");
            }
        }
    }

    public void recordsDirectoryDialog() {
        String location = this.openOpenDialog("RecordsDirectory");
        if (location != null && this.isDirectory(location)) {
            this.getCurrentlySelectedFIT().setRecordsDirectory(location);
        }
    }

    public void startSelectedRecordInViewer() {
        int selectedRow = this._table.getSelectedRow();
        if (!this.getCurrentlySelectedFIT().startViewer(selectedRow)) {
            this._messages.message("It was not possible to invoke viewer.");
        } else {
            this.getCurrentlySelectedFIT().markViewed(selectedRow);
        }
    }

    public void reviewerInfo() {
        String name = null;
        if (this._whenMouseClicked > this._popupListener.getWhen()) {
            int selectedRow = this._table.getSelectedRow();
            int selectedColumn = this._table.getSelectedColumn();
            name = this.getCurrentlySelectedFIT().getReviewersName(selectedRow, selectedColumn);
        } else {
            PointJ where = this._popupListener.getWhere();
            name = this.getCurrentlySelectedFIT().getReviewersName(where.getY(), where.getX());
        }
        if (name != null) {
            new HtmlInfoDialog((Frame)this._frame, name);
        } else {
            this._messages.message("Could not get name of reviewer!");
        }
    }

    public void saveSets() {
        if (!Preferences.getPreferences().store()) {
            this._messages.message("Settings saved.");
        } else {
            this._messages.message("Failed to save settings.");
        }
    }

    public void saveSets(Vector selectedProperties) {
        if (!Preferences.getPreferences().store(selectedProperties, this.getPlaylistModel().getFilenames(), this.getPlaylistModel().getCorrespondingIDByIndex(this._playlist.getSelectedRow())) && selectedProperties != null) {
            this._messages.message("Settings saved.");
        } else if (selectedProperties != null) {
            this._messages.message("Failed to save settings.");
        }
    }

    public void tableChanged(TableModelEvent e) {
        this._frame.repaint();
    }

    public void setItemListenerStateActive(boolean switcher) {
        this._itemListenerActive = switcher;
    }

    public void itemStateChanged(ItemEvent e) {
        if (this._itemListenerActive && (e.getStateChange() == 1 || e.getStateChange() == 2)) {
            boolean selected;
            JMenuItem source = (JMenuItem)e.getItemSelectable();
            String command = source.getActionCommand();
            boolean bl = selected = e.getStateChange() == 1;
            if (command.endsWith("Sort")) {
                this.getCurrentlySelectedFIT().setSorting(command.substring(0, command.indexOf("Sort")));
                this.getCurrentlySelectedFIT().sort();
            } else if (command.equals("look for collections")) {
                this.getCurrentlySelectedFIT().useCollections(selected);
            } else if (command.equals("edit comments with editor")) {
                this.getCurrentlySelectedFIT().useEditor(selected);
            } else if (command.equals("show Splashscreen on startup")) {
                Preferences.getPreferences().setProperty(5, "" + selected);
            } else if (command.equals("use dynamic shortcuts")) {
                Preferences.getPreferences().setProperty(20, "" + selected);
            } else if (command.equals("recurse into subdirectories on drop")) {
                Preferences.getPreferences().setProperty(18, "" + selected);
            } else if (command.equals("devil with Drag&Drop-ability")) {
                Preferences.getPreferences().setProperty(24, "" + selected);
            } else if (this.getCurrentlySelectedFIT().isInfo(command)) {
                this.getCurrentlySelectedFIT().setShownInfo(command, selected);
            } else {
                System.out.println("Jacoto.itemStateChanged(): not caught!");
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this._whenMouseClicked = e.getWhen();
        if (e.getClickCount() == 2) {
            this.startSelectedRecordInViewer();
        }
    }

    public long getWhenMouseClicked() {
        return this._whenMouseClicked;
    }

    private String openSaveDialog(String info, String filenameProposal) {
        JFileChooser chooser = new JFileChooser(this.getCurrentlySelectedFIT().getWorkingDirectory().getAbsolutePath() + filenameProposal);
        if (info.equals("Save")) {
            chooser.setFileFilter(new JacFilter());
        } else if (info.equals("Exporting as Textfile")) {
            chooser.setFileFilter(new TxtFilter());
        }
        int returnVal = chooser.showSaveDialog(this._frame);
        if (returnVal == 0) {
            String directory = chooser.getCurrentDirectory().getAbsolutePath() + System.getProperty("file.separator");
            String filename = chooser.getSelectedFile().getName();
            return directory + filename;
        }
        return null;
    }

    private String openOpenDialog(String info) {
        JFileChooser chooser = new JFileChooser();
        chooser.setLocation(this.calculateDialogLocation(chooser));
        chooser.setCurrentDirectory(this.getCurrentlySelectedFIT().getWorkingDirectory());
        if (info.equals("Open")) {
            chooser.setFileFilter(new JacFilter());
        } else if (info.equals("Adding Recordfile")) {
            chooser.setFileFilter(new SGFnXMLFilter());
            chooser.setCurrentDirectory(this.getCurrentlySelectedFIT().getRecordsDirectory());
        } else if (info.equals("ViewerLocation")) {
            chooser.setFileSelectionMode(1);
            chooser.setCurrentDirectory(new File(this.getCurrentlySelectedFIT().getViewerLocation()));
        } else if (info.equals("RecordsDirectory")) {
            chooser.setFileSelectionMode(1);
            chooser.setCurrentDirectory(this.getCurrentlySelectedFIT().getRecordsDirectory());
        }
        int returnVal = chooser.showOpenDialog(this._frame);
        if (returnVal == 0) {
            return chooser.getSelectedFile().getAbsoluteFile().toString();
        }
        if (returnVal == 1 && (info.equals("ViewerLocation") || info.equals("RecordsDirectory"))) {
            JOptionPane pane = new JOptionPane("Please select a directory (do NOT double-click it) \nand press the Open-Button.\nWould you like to try again?", 2, 0);
            JDialog dialog = pane.createDialog(this._frame, "Hint");
            dialog.show();
            Object selectedValue = pane.getValue();
            if (selectedValue == null) {
                return null;
            }
            if ((Integer)selectedValue == 0) {
                return this.openOpenDialog(info);
            }
            return null;
        }
        return null;
    }

    private boolean openAskNewWorkingDir(String newDir, String oldDir) {
        int select = JOptionPane.showConfirmDialog(this._frame, "Would you like to make  " + newDir + "  your new RecordsDirectory?\nCurrently it is  " + oldDir + ".", "Changing RecordsDirectory", 0, 3);
        return select == 0;
    }

    private boolean isDirectory(String location) {
        return new File(location).isDirectory();
    }

    private String extractDirectory(String location) {
        int index = location.lastIndexOf(System.getProperty("file.separator"));
        if (index >= 0) {
            return location.substring(0, index);
        }
        return location;
    }

    public Point getPosition() {
        return this._position;
    }

    public void sort(int column) {
        this.getCurrentlySelectedFIT().setSorting(column);
        this.sort();
    }

    public void sort() {
        this.getCurrentlySelectedFIT().sort();
    }

    private int parseIntFromProperty(int property) {
        return Integer.parseInt(Preferences.getPreferences().getProperty(property));
    }

    public static void main(String[] args) {
        if (System.getProperty("mrj.version") == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Jacoto jacoto = new Jacoto(args);
    }

    public JTable getTable() {
        return this._table;
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public FileInfoTableModel getFIT() {
        return this.getCurrentlySelectedFIT();
    }

    public MessageDialogs getMessages() {
        return this._messages;
    }

    public TableSearcher getTableSearcher() {
        return this._tableSearcher;
    }

    public TablePopupListener getPopupListener() {
        return this._popupListener;
    }

    public Point calculateDialogLocation(Component component) {
        return new Point((int)this._frame.getLocationOnScreen().getX() + this._frame.getSize().width / 2 - component.getSize().width / 2, (int)this._frame.getLocationOnScreen().getY() + this._frame.getSize().height / 2 - component.getSize().height / 2);
    }

    private static void globalExceptionHandling(RuntimeException e) {
        StringBuffer messageText = new StringBuffer();
        messageText.append("Exception of type: " + e.getClass().getName());
        messageText.append(Jacoto.stack2string(e));
        MessageDialogs.showExceptionMessage(messageText.toString());
    }

    public static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "------\r\n" + sw.toString() + "------\r\n";
        }
        catch (Exception e2) {
            return "Error in Jacoto.stack2string(Exception).";
        }
    }

    public void playSong(int index) {
        this.initSelectedPlaylistItemForDisplay(this.getPlaylistModel().getFilenameMatchingIndex(index));
    }

    private PlaylistModel getPlaylistModel() {
        return (PlaylistModel)this._playlist.getModel();
    }

    public void handleAbout() {
        this.versionDialog();
    }

    public void handleOpenApplication() {
    }

    public void handleOpenFile(File aFile) {
    }

    public void handleQuit() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Jacoto.this.close();
            }
        });
        throw new IllegalStateException("Quit Pending User Confirmation");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

