/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.auxiliary;

import de.gungfu.jacoto.logic.auxiliary.RankParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Date;
import javax.swing.JPanel;

public class RankDevelopmentPanel
extends JPanel {
    int[] dataX;
    int[] dataY;
    int sizeGraphX;
    int sizeGraphY;
    int sizeX;
    int sizeY;
    int marginX = 100;
    int marginY = 75;
    int DistanceY = 5;
    Color Green = new Color(0, 128, 0);
    int start;
    int startRank;
    int end;
    int endRank;
    int average;
    int averageRank;
    final int Zeit = 1;
    final int Rank = 0;

    public RankDevelopmentPanel(long[][] dev) {
        this.dataX = new int[dev.length];
        this.dataY = new int[dev.length];
        long now = new Date().getTime();
        long divisor1 = this.powerL(8);
        dev = this.selectionSort(dev);
        int stellen = this.calcStellen((now - dev[0][1]) / divisor1);
        int divisor2 = this.power(stellen - 3);
        int i = 0;
        while (i < dev.length) {
            this.dataY[i] = (int)((dev[i][0] + 30L) * (long)this.DistanceY);
            this.dataX[i] = (int)((now - dev[i][1]) / (divisor1 * (long)divisor2));
            ++i;
        }
        this.startRank = (int)dev[0][0];
        this.endRank = (int)dev[dev.length - 1][0];
        this.averageRank = this.getAverage(dev);
        this.sizeGraphX = this.dataX[0];
        this.sizeGraphY = this.getMaxY(this.dataY) + 3 * this.DistanceY;
        this.sizeX = this.sizeGraphX + this.marginX;
        this.sizeY = this.sizeGraphY + this.marginY;
        this.start = this.dataY[0];
        this.end = this.dataY[this.dataY.length - 1];
        this.average = (this.averageRank + 30) * this.DistanceY;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawGrid(g);
        if (this.start != this.end) {
            g.setColor(Color.red);
            g.drawLine(0, this.start, this.sizeGraphX, this.start);
            g.drawString(RankParser.getRank(this.startRank), this.sizeGraphX + 15, this.start);
            g.setColor(Color.blue);
            g.drawLine(0, this.end, this.sizeGraphX, this.end);
            g.drawString(RankParser.getRank(this.endRank), this.sizeGraphX + 15, this.end);
        } else {
            g.setColor(Color.red);
            g.drawLine(0, this.start, this.sizeGraphX, this.start);
            g.drawString(RankParser.getRank(this.startRank), this.sizeGraphX + 15, this.start);
        }
        g.setColor(Color.cyan);
        g.drawLine(0, this.average, this.sizeGraphX, this.average);
        this.drawChart(g);
        this.drawArrowRank(g);
        this.drawArrowTime(g);
    }

    protected void drawChart(Graphics g) {
        g.setColor(Color.black);
        int i = 0;
        while (i < this.dataX.length - 1) {
            g.drawLine(this.sizeGraphX - this.dataX[i], this.dataY[i], this.sizeGraphX - this.dataX[i + 1], this.dataY[i + 1]);
            ++i;
        }
    }

    protected void drawGrid(Graphics g) {
        g.setColor(Color.gray);
        int y = 0;
        while (y < this.sizeGraphY) {
            g.drawLine(0, y, this.sizeGraphX, y);
            y += this.DistanceY;
        }
    }

    protected void drawArrowRank(Graphics g) {
        g.setColor(this.Green);
        g.drawLine(this.sizeGraphX + 65, 30, this.sizeGraphX + 65, 105);
        g.drawLine(this.sizeGraphX + 65, 105, this.sizeGraphX + 70, 95);
        g.drawLine(this.sizeGraphX + 65, 105, this.sizeGraphX + 60, 95);
        g.drawString("stronger", this.sizeGraphX + 40, 120);
    }

    protected void drawArrowTime(Graphics g) {
        g.setColor(this.Green);
        g.drawLine(this.sizeGraphX / 3, this.sizeGraphY + 20, this.sizeGraphX / 3 + 75, this.sizeGraphY + 20);
        g.drawLine(this.sizeGraphX / 3 + 75, this.sizeGraphY + 20, this.sizeGraphX / 3 + 65, this.sizeGraphY + 15);
        g.drawLine(this.sizeGraphX / 3 + 75, this.sizeGraphY + 20, this.sizeGraphX / 3 + 65, this.sizeGraphY + 25);
        g.drawString("newer", this.sizeGraphX / 3 + 25, this.sizeGraphY + 35);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.sizeX, this.sizeY);
    }

    protected int getMaxY(int[] data) {
        int maximum = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > maximum) {
                maximum = data[i];
            }
            ++i;
        }
        return maximum;
    }

    protected int getAverage(long[][] data) {
        int sum = 0;
        int i = 0;
        while (i < data.length) {
            sum += (int)data[i][0];
            ++i;
        }
        return sum / data.length;
    }

    protected int calcStellen(long maximum) {
        int index = 0;
        while (maximum > 0L) {
            maximum /= 10L;
            ++index;
        }
        return index;
    }

    protected int power(int stellen) {
        int result;
        if (stellen > 0) {
            result = 10;
            int i = 1;
            while (i < stellen) {
                result *= 10;
                ++i;
            }
        } else {
            result = 1;
        }
        return result;
    }

    protected long powerL(int stellen) {
        long result;
        if (stellen > 0) {
            result = 10L;
            int i = 1;
            while (i < stellen) {
                result *= 10L;
                ++i;
            }
        } else {
            result = 1L;
        }
        return result;
    }

    protected long[][] selectionSort(long[][] dev) {
        int N = dev.length - 1;
        int i = 0;
        while (i < N) {
            int min = i;
            int j = i + 1;
            while (j <= N) {
                if (dev[j][1] < dev[min][1]) {
                    min = j;
                }
                ++j;
            }
            this.swap(dev, min, i);
            ++i;
        }
        return dev;
    }

    protected void swap(long[][] dev, int i, int j) {
        long[] t = dev[i];
        dev[i] = dev[j];
        dev[j] = t;
    }

    private static void deb(String s) {
        System.out.println(s);
    }
}

