/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.auxiliary;

import de.gungfu.jacoto.Jacoto;
import de.gungfu.jacoto.auxiliary.RankDevelopmentPanel;
import de.gungfu.jacoto.logic.statistics.Statistics;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StatisticsViewer {
    private Jacoto _jac;

    public StatisticsViewer(Jacoto jac) {
        this._jac = jac;
    }

    public void history() {
        int selectedRow = this._jac.getTable().getSelectedRow();
        int selectedColumn = this._jac.getTable().getSelectedColumn();
        Vector history = this._jac.getFIT().getHistory(selectedRow, selectedColumn);
        if (history == null) {
            this._jac.getMessages().message("It was not possible to create history.");
        } else {
            this.showHistory(history);
        }
    }

    public void rankDev() {
        int selectedRow = this._jac.getTable().getSelectedRow();
        int selectedColumn = this._jac.getTable().getSelectedColumn();
        long[][] development = this._jac.getFIT().getRankDevelopment(selectedRow, selectedColumn);
        if (development == null) {
            this._jac.getMessages().message("It was not possible to create rank development.");
        } else {
            JDialog dialog = new JDialog((Frame)this._jac.getFrame(), "Rank Development");
            RankDevelopmentPanel rdp = new RankDevelopmentPanel(development);
            dialog.getContentPane().add(rdp);
            ((Component)dialog).setLocation((int)this._jac.getPosition().getX() + 50, (int)this._jac.getPosition().getY() - 50);
            ((Component)dialog).setSize(rdp.getPreferredSize());
            ((Component)dialog).setVisible(true);
        }
    }

    public void statCP() {
        int selectedRow = this._jac.getTable().getSelectedRow();
        int selectedColumn = this._jac.getTable().getSelectedColumn();
        Vector result = this._jac.getFIT().getStatisticsOfPlayerByColor(selectedRow, selectedColumn);
        if (result == null) {
            this.mesEmptyStat();
        } else {
            String name = (String)result.remove(0);
            this.showStatisticsOfOneByColor(result, name);
        }
    }

    public void statWLJ() {
        int selectedRow = this._jac.getTable().getSelectedRow();
        int selectedColumn = this._jac.getTable().getSelectedColumn();
        Statistics s = this._jac.getFIT().getStatisticsPlayer(selectedRow, selectedColumn);
        if (s == null) {
            this._jac.getMessages().message("Please select player to get statistic.");
        } else {
            this.showStatistics(s, s.getName());
        }
    }

    public void statPB() {
        Statistics s = this._jac.getFIT().getStatisticsAllPlayerByColor("black");
        if (s == null) {
            this.mesEmptyStat();
        } else {
            this.showStatistics(s, "Black");
        }
    }

    public void statPW() {
        Statistics s = this._jac.getFIT().getStatisticsAllPlayerByColor("white");
        if (s == null) {
            this.mesEmptyStat();
        } else {
            this.showStatistics(s, "White");
        }
    }

    public void listAP() {
        Vector bestPlayer = this._jac.getFIT().getStatisticsAllPlayer();
        if (bestPlayer == null) {
            this.mesEmptyStat();
        } else {
            this.showStatistics(bestPlayer, bestPlayer.size() + " player");
        }
    }

    public void listBP() {
        Vector bestPlayer = this._jac.getFIT().getStatisticsBestPlayer();
        if (bestPlayer == null) {
            this.mesEmptyStat();
        } else {
            this.showStatistics(bestPlayer, "best player");
        }
    }

    public void list10BP() {
        Vector bestPlayer = this._jac.getFIT().getStatisticsBestPlayerRanking();
        if (bestPlayer == null) {
            this.mesEmptyStat();
        } else {
            this.showStatistics(bestPlayer, "10 best player");
        }
    }

    public void list10MCR() {
        Vector results = this._jac.getFIT().getStatisticsMostCommonResults();
        if (results == null) {
            this.mesEmptyStat();
        } else {
            this.showStatisticsMostCommon(results);
        }
    }

    private void showStatistics(Vector s, String who) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Name");
        columnNames.add("Won");
        columnNames.add("Lost");
        columnNames.add("Jigo");
        columnNames.add("Total");
        Vector rowData = new Vector();
        Vector<String> row = null;
        int i = 0;
        while (i < s.size()) {
            row = new Vector<String>();
            Statistics sta = (Statistics)s.elementAt(i);
            int total = sta.getWon() + sta.getLost() + sta.getJigo();
            int percW = StatisticsViewer.getPercent(sta.getWon(), total);
            int percL = StatisticsViewer.getPercent(sta.getLost(), total);
            int percJ = StatisticsViewer.getPercent(sta.getJigo(), total);
            row.add("" + sta.getName());
            row.add(sta.getWon() + " (" + percW + "%)");
            row.add(sta.getLost() + " (" + percL + "%)");
            row.add(sta.getJigo() + " (" + percJ + "%)");
            row.add("" + total);
            rowData.add(row);
            ++i;
        }
        if (who != null) {
            this.showStatisticsDialog(rowData, columnNames, who);
        } else {
            this.showStatisticsDialog(rowData, columnNames);
        }
    }

    private void showStatistics(Vector s) {
        this.showStatistics(s, null);
    }

    private void showStatisticsMostCommon(Vector s) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Result");
        columnNames.add("Occurance");
        columnNames.add("Percentage");
        int size = this._jac.getFIT().getSize();
        Vector rowData = new Vector();
        Vector<String> row = null;
        int i = 0;
        while (i < s.size()) {
            row = new Vector<String>();
            Statistics sta = (Statistics)s.elementAt(i);
            int won = sta.getWon();
            row.add("" + sta.getName());
            row.add("" + won);
            row.add("" + StatisticsViewer.getPercent(won, size) + "%");
            rowData.add(row);
            ++i;
        }
        this.showStatisticsDialog(rowData, columnNames);
    }

    private void showStatisticsOfOneByColor(Vector result, String name) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Color played");
        columnNames.add("Won");
        columnNames.add("Lost");
        columnNames.add("Jigo");
        columnNames.add("Total");
        Vector rowData = new Vector();
        Vector<String> row = null;
        int i = 0;
        while (i < 2) {
            row = new Vector<String>();
            Statistics sta = (Statistics)result.elementAt(i);
            int total = sta.getWon() + sta.getLost() + sta.getJigo();
            int percW = StatisticsViewer.getPercent(sta.getWon(), total);
            int percL = StatisticsViewer.getPercent(sta.getLost(), total);
            int percJ = StatisticsViewer.getPercent(sta.getJigo(), total);
            if (i == 0) {
                row.add("Black");
            } else {
                row.add("White");
            }
            row.add(sta.getWon() + " (" + percW + "%)");
            row.add(sta.getLost() + " (" + percL + "%)");
            row.add(sta.getJigo() + " (" + percJ + "%)");
            row.add("" + total);
            rowData.add(row);
            ++i;
        }
        this.showStatisticsDialog(rowData, columnNames, name);
    }

    private static int getPercent(int amount, int from) {
        return (int)((double)amount / (double)from * 100.0);
    }

    private void showHistory(Vector history) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("own rank");
        columnNames.add("opponent's name");
        columnNames.add("opponent's rank");
        columnNames.add("result");
        String name = (String)history.remove(0);
        Vector rowData = history;
        this.showStatisticsDialog(rowData, columnNames, name);
    }

    private void showStatistics(Statistics s, String who) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Won");
        columnNames.add("Lost");
        columnNames.add("Jigo");
        columnNames.add("Total");
        Vector rowData = new Vector();
        Vector<String> row = new Vector<String>();
        int total = s.getWon() + s.getLost() + s.getJigo();
        int percW = StatisticsViewer.getPercent(s.getWon(), total);
        int percL = StatisticsViewer.getPercent(s.getLost(), total);
        int percJ = StatisticsViewer.getPercent(s.getJigo(), total);
        row.add(s.getWon() + " (" + percW + "%)");
        row.add(s.getLost() + " (" + percL + "%)");
        row.add(s.getJigo() + " (" + percJ + "%)");
        row.add("" + total);
        rowData.add(row);
        this.showStatisticsDialog(rowData, columnNames, who);
    }

    private void showStatisticsDialog(Vector rowData, Vector columnNames) {
        this.showStatisticsDialog(rowData, columnNames, null);
    }

    private void showStatisticsDialog(Vector rowData, Vector columnNames, String who) {
        JTable t = new JTable(rowData, columnNames){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == this.getColumnCount() - 1) {
                    String result = (String)this.getValueAt(row, column);
                    if (result.startsWith("Won")) {
                        this.setForeground(new Color(0, 128, 0));
                    } else if (result.startsWith("Lost")) {
                        this.setForeground(new Color(192, 0, 0));
                    }
                } else {
                    this.setForeground(Color.black);
                }
                return super.getCellRenderer(row, column);
            }
        };
        int rowHeight = t.getRowHeight();
        if (rowData.size() <= 10) {
            t.setPreferredScrollableViewportSize(new Dimension(350, rowData.size() * rowHeight));
        } else {
            t.setPreferredScrollableViewportSize(new Dimension(350, 20 * rowHeight));
        }
        JScrollPane pane = new JScrollPane(t);
        final JDialog dialog = who != null ? new JDialog((Frame)this._jac.getFrame(), "Statistics for " + who) : new JDialog((Frame)this._jac.getFrame(), "Statistics");
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)pane, "Center");
        JButton b = new JButton("Ok");
        b.setPreferredSize(new Dimension(50, 50));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((Component)dialog).setVisible(false);
                dialog.dispose();
            }
        });
        dialog.getContentPane().add((Component)b, "South");
        ((Component)dialog).setLocation((int)this._jac.getPosition().getX() + 50, (int)this._jac.getPosition().getY() + 50);
        dialog.pack();
        ((Component)dialog).setVisible(true);
    }

    private void mesEmptyStat() {
        this._jac.getMessages().message("This table is empty or not a name was selected. Cannot create statistic.");
    }
}

