/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.auxiliary;

import de.gungfu.jacoto.Jacoto;
import de.gungfu.jacoto.gui.auxiliary.MessageDialogs;
import de.gungfu.jacoto.gui.menu.TablePopupListener;
import de.gungfu.jacoto.logic.FileInfoTableModel;
import de.gungfu.jacoto.logic.auxiliary.PointJ;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class TableSearcher {
    private Jacoto _jac;
    private FileInfoTableModel _fit;
    private MessageDialogs _messages;
    private JFrame _frame;
    private JTable _table;
    private TablePopupListener _popupListener;

    public TableSearcher(Jacoto jac) {
        this._jac = jac;
        this._messages = this._jac.getMessages();
        this._frame = this._jac.getFrame();
        this._table = this._jac.getTable();
        this._popupListener = this._jac.getPopupListener();
    }

    public void searchPlayer() {
        if (this._fit.isEmptyTable()) {
            this._messages.mesEmptySearch();
        } else {
            String name = JOptionPane.showInputDialog(this._frame, (Object)"Please type in the name of the player to be searched.");
            int row = this._fit.search(name);
            if (row >= 0) {
                this._table.addRowSelectionInterval(row, row);
                this._table.changeSelection(row, 0, true, true);
            } else if (name != null && name.length() > 0) {
                this._messages.message("\"" + name + "\" (ignoring case) has not been found in this table.");
            } else {
                this._messages.message("You have to type the player's name.");
            }
        }
    }

    public void searchSelected() {
        if (this._fit.isEmptyTable()) {
            this._messages.mesEmptySearch();
        } else {
            Object name = null;
            int row = -1;
            if (this._jac.getWhenMouseClicked() > this._popupListener.getWhen()) {
                int selectedRow = this._table.getSelectedRow();
                int selectedColumn = this._table.getSelectedColumn();
                row = this._fit.search(selectedRow, selectedColumn);
            } else {
                PointJ where = this._popupListener.getWhere();
                row = this._fit.search(where.getY(), where.getX());
            }
            if (row >= 0) {
                this._table.addRowSelectionInterval(row, row);
                this._table.changeSelection(row, 0, true, true);
            } else {
                this._messages.message("The selected player has not been found in this table again.");
            }
        }
    }

    public void searchNext() {
        if (this._fit.isEmptyTable()) {
            this._messages.mesEmptySearch();
        } else {
            int row = this._fit.searchNext();
            if (row >= 0) {
                this._table.addRowSelectionInterval(row, row);
                this._table.changeSelection(row, 0, true, true);
            } else {
                this._messages.message("The selected name has not been found in this table again.");
            }
        }
    }

    public void searchAgain() {
        if (this._fit.isEmptyTable()) {
            this._messages.mesEmptySearch();
        } else {
            int row = this._fit.searchAgain();
            if (row >= 0) {
                this._table.addRowSelectionInterval(row, row);
                this._table.changeSelection(row, 0, true, true);
            } else {
                this._messages.message("The selected name has not been found in this table again.");
            }
        }
    }

    public void searchSelectedReviewer() {
        if (this._fit.isEmptyTable()) {
            this._messages.mesEmptySearch();
        } else {
            Object name = null;
            int row = -1;
            if (this._jac.getWhenMouseClicked() > this._popupListener.getWhen()) {
                int selectedRow = this._table.getSelectedRow();
                int selectedColumn = this._table.getSelectedColumn();
                row = this._fit.search(selectedRow, selectedColumn);
            } else {
                PointJ where = this._popupListener.getWhere();
                row = this._fit.searchReviewer(where.getY(), where.getX());
            }
            if (row >= 0) {
                this._table.addRowSelectionInterval(row, row);
                this._table.changeSelection(row, 0, true, true);
            } else {
                this._messages.message("The selected reviewer has not been found in this table again.");
            }
        }
    }

    public void searchReviewer() {
        if (this._fit.isEmptyTable()) {
            this._messages.mesEmptySearch();
        } else {
            String name = JOptionPane.showInputDialog(this._frame, (Object)"Please type in the name of the reviewer to be searched.");
            int row = this._fit.searchReviewer(name);
            if (row >= 0) {
                this._table.addRowSelectionInterval(row, row);
                this._table.changeSelection(row, 0, true, true);
            } else if (name != null && name.length() > 0) {
                this._messages.message("\"" + name + "\" (ignoring case) has not been found in this table.");
            } else {
                this._messages.message("You have to type the reviewer's name.");
            }
        }
    }

    public void searchComments() {
        if (this._fit.isEmptyTable()) {
            this._messages.mesEmptySearch();
        } else {
            String name = JOptionPane.showInputDialog(this._frame, (Object)"Please type in the String to be searched in the comments.");
            int row = this._fit.searchComments(name);
            if (row >= 0) {
                this._table.addRowSelectionInterval(row, row);
                this._table.changeSelection(row, 0, true, true);
            } else if (name != null && name.length() > 0) {
                this._messages.message("\"" + name + "\" (ignoring case) has not been found in this table.");
            } else {
                this._messages.message("You have to type something here!");
            }
        }
    }
}

