/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.auxiliary;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class MessageDialogs {
    private JFrame _frame;

    public MessageDialogs(JFrame frame) {
        this._frame = frame;
    }

    public void message(String message, String title) {
        JTextArea area = this.createTextareaFromString(message);
        JOptionPane pane = new JOptionPane(area, 1, -1);
        this.setUpDialog(title, pane);
    }

    public void message(String message) {
        this.message(message, "Message");
    }

    public void mesEmptySearch() {
        this.message("This table is empty or not a name was selected. Nothing to be searched.");
    }

    public void loadMessage(int number) {
        String message = number != -1 ? (number > 1 ? number + " files were added to the table." : (number == 1 ? "One file was added to the table." : "No file was added to the table.")) : "There was no directory containing the records given!";
        this.message(message);
    }

    public int messageOkCancelOption(String message, String title) {
        JTextArea area = this.createTextareaFromString(message);
        JOptionPane pane = new JOptionPane(area, 1, 2);
        this.setUpDialog(title, pane);
        return (Integer)pane.getValue();
    }

    public static void showExceptionMessage(String message) {
        JTextArea area = new JTextArea(message + "\n\n::Please copy the above text into an email and send it to jacoto@gungfu.de::");
        area.setEditable(false);
        area.setBackground(((Component)new JFrame()).getBackground());
        JOptionPane.showMessageDialog(null, area, "An error occured!", 1);
    }

    private JTextArea createTextareaFromString(String message) {
        JTextArea area = new JTextArea(message);
        area.setEditable(false);
        area.setBackground(((Component)this._frame).getBackground());
        return area;
    }

    public void setUpDialog(String title, JOptionPane pane) {
        JDialog dialog = pane.createDialog(this._frame, title);
        ((Component)dialog).setLocation(this.calculateDialogLocation(dialog));
        dialog.pack();
        dialog.show();
    }

    public Point calculateDialogLocation(Component component) {
        return new Point((int)this._frame.getLocationOnScreen().getX() + this._frame.getSize().width / 2 - component.getSize().width / 2, (int)this._frame.getLocationOnScreen().getY() + this._frame.getSize().height / 2 - component.getSize().height / 2);
    }
}

