/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.auxiliary;

import de.gungfu.jacoto.logic.auxiliary.PointJ;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;

public abstract class PopupListener
extends MouseAdapter {
    protected JPopupMenu _popup;
    protected ActionListener _listener;

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    protected abstract void maybeShowPopup(MouseEvent var1);

    protected void clear() {
        this._popup = new JPopupMenu();
    }

    protected Dimension calculatePopupPosition(MouseEvent e) {
        int margin = 20;
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        PointJ parentRelLocation = PointJ.transformFromPoint(this.getFrameParent(e.getComponent()).getLocationOnScreen());
        int posX = e.getX();
        int posY = e.getY();
        int absolutePositionX = posX + parentRelLocation.getX();
        int absolutePositionY = posY + parentRelLocation.getY();
        int popSizeY = this._popup.getHeight();
        int popSizeX = this._popup.getWidth();
        int newPosX = absolutePositionX + popSizeX > size.width ? posX - popSizeX : posX;
        int newPosY = absolutePositionY + popSizeY > size.height ? posY - popSizeY : posY;
        return new Dimension(newPosX, newPosY);
    }

    protected Container getFrameParent(Component cont) {
        Container frame = cont.getParent();
        while (!(frame instanceof Frame)) {
            frame = frame.getParent();
        }
        return frame;
    }
}

