/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.auxiliary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class SplashScreen
extends JWindow
implements Runnable {
    String _image = "/splash.gif";
    String _text = "(C) Copyright 2000-2002, Steffen Gl\u00b8ckselig, All Rights Reserved";
    private boolean _finished = false;
    private boolean _hasFinishedLoading = false;
    private final Color _foreground = new Color(102, 154, 51);
    private final int _timeShowing = 5000;
    private Dimension _iconDimension;
    private static SplashScreen _splashScreen;
    static /* synthetic */ Class class$de$gungfu$jacoto$gui$auxiliary$SplashScreen;

    public static void splashScreenOff() {
        if (_splashScreen != null) {
            _splashScreen.finishedLoadingTable();
            while (!_splashScreen.isFinished()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void splashScreenOn(String VERSION, String RELEASE_DATE) {
        _splashScreen = new SplashScreen(VERSION, RELEASE_DATE);
        new Thread(_splashScreen).start();
    }

    public SplashScreen(String version, String date) {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBackground(new Color(254, 254, 238));
        Border bd1 = BorderFactory.createBevelBorder(0);
        Border bd2 = BorderFactory.createEtchedBorder();
        CompoundBorder bd3 = BorderFactory.createCompoundBorder(bd1, bd2);
        contentPane.setBorder(bd3);
        ImageIcon icon = new ImageIcon((class$de$gungfu$jacoto$gui$auxiliary$SplashScreen == null ? (class$de$gungfu$jacoto$gui$auxiliary$SplashScreen = SplashScreen.class$("de.gungfu.jacoto.gui.auxiliary.SplashScreen")) : class$de$gungfu$jacoto$gui$auxiliary$SplashScreen).getResource(this._image));
        this._iconDimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        JLabel textLabelNorth = new JLabel(" " + version + "  from  " + date, 2);
        textLabelNorth.setForeground(this._foreground);
        contentPane.add("North", textLabelNorth);
        contentPane.add("Center", new JLabel(icon, 0));
        JLabel textLabelSouth = new JLabel(this._text, 0);
        textLabelSouth.setForeground(this._foreground);
        contentPane.add("South", textLabelSouth);
        this.setContentPane(contentPane);
    }

    private void showFor(int millis) {
        this.showSplash();
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void showSplash() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dim.width - this._iconDimension.width) / 2, (dim.height - this._iconDimension.height) / 2);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void run() {
        this.showFor(5000);
        this.finished();
        while (!this.isFinishedLoading()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ((Component)this).setVisible(false);
    }

    public void finishedLoadingTable() {
        this._hasFinishedLoading = true;
    }

    private boolean isFinishedLoading() {
        return this._hasFinishedLoading;
    }

    private void finished() {
        this._finished = true;
    }

    public boolean isFinished() {
        return this._finished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

