/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.dialog;

import de.gungfu.jacoto.gui.dialog.CommentTextFieldListener;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class CommentEditor
extends DefaultCellEditor {
    protected String _currentComment = null;
    protected TableCellEditor _defaultEditor;
    private KeyListener _textFieldListener;
    private JTextField _field;

    public CommentEditor(JButton b, TableCellEditor defaultEditor, CommentTextFieldListener textFieldListener) {
        super(new JTextField());
        this._defaultEditor = defaultEditor;
        this._textFieldListener = textFieldListener;
        this.editorComponent = b;
        this.setClickCountToStart(1);
        this.addListeners(b);
    }

    private void addListeners(JButton b) {
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommentEditor.this.fireEditingStopped();
            }
        });
        this.addKeyListener(b);
    }

    private void addKeyListener(Component b) {
        b.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CommentEditor.this.fireEditingStopped();
                }
            }
        });
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        if (Boolean.valueOf(Preferences.getPreferences().getProperty(6)).booleanValue()) {
            return this._currentComment;
        }
        return this._defaultEditor.getCellEditorValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._currentComment = (String)value;
        if (Boolean.valueOf(Preferences.getPreferences().getProperty(6)).booleanValue()) {
            ((JButton)this.editorComponent).setText(this._currentComment);
            return this.editorComponent;
        }
        Component currentComponent = this._defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        this._currentComment = (String)value;
        this.addKeyListener(currentComponent);
        return currentComponent;
    }
}

