/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.dialog;

import de.gungfu.jacoto.auxiliary.LocationCalculator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectablePropertiesDialog
extends JDialog
implements ActionListener {
    private Vector _checkBoxes = new Vector();
    JButton _buttonSave;
    JButton _buttonNoSave;
    JButton _buttonCancel;
    private Integer selectedButton;
    public static final int SAVE_OPTION = 0;
    public static final int NO_SAVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;

    public SelectablePropertiesDialog(Frame parent, LocationCalculator locator, String title, String[] properties, boolean[] selections) {
        super(parent, title);
        this.getContentPane().setLayout(new BorderLayout());
        JLabel labelTop = new JLabel("Please select the properties you'd like to save:");
        this.getContentPane().add((Component)labelTop, "North");
        this._buttonSave = new JButton("Save selected");
        this._buttonSave.addActionListener(this);
        this._buttonNoSave = new JButton("Don't save any");
        this._buttonNoSave.addActionListener(this);
        this._buttonCancel = new JButton("Cancel");
        this._buttonCancel.addActionListener(this);
        JPanel panelBottom = new JPanel();
        panelBottom.setLayout(new GridLayout(1, 3));
        panelBottom.add(this._buttonSave);
        panelBottom.add(this._buttonNoSave);
        panelBottom.add(this._buttonCancel);
        this.getContentPane().add((Component)panelBottom, "South");
        JPanel panelCenter = new JPanel();
        panelCenter.setLayout(new GridLayout(properties.length, 1));
        this.setUpJCheckBoxes(panelCenter, properties, selections);
        this.getContentPane().add((Component)panelCenter, "Center");
        JLabel spaceToLeft = new JLabel("");
        spaceToLeft.setPreferredSize(new Dimension(50, 50));
        this.getContentPane().add((Component)spaceToLeft, "West");
        ((Component)this).setLocation(locator.calculateDialogLocation(this));
        this.setModal(true);
        this.pack();
        this.show();
    }

    private void setUpJCheckBoxes(JPanel panel, String[] content, boolean[] selections) {
        int index = 0;
        while (index < content.length) {
            JCheckBox currentCheckBox = new JCheckBox(content[index], selections[index]);
            this._checkBoxes.add(currentCheckBox);
            panel.add(currentCheckBox);
            ++index;
        }
    }

    public Integer getSelectedButton() {
        return this.selectedButton;
    }

    public Vector getSelectedProperties() {
        Vector<String> result = new Vector<String>();
        Enumeration enumeration = this._checkBoxes.elements();
        while (enumeration.hasMoreElements()) {
            JCheckBox element = (JCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            result.add(element.getText());
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        this.selectedButton = e.getSource().equals(this._buttonSave) ? new Integer(0) : (e.getSource().equals(this._buttonNoSave) ? new Integer(1) : (e.getSource().equals(this._buttonCancel) ? new Integer(2) : null));
        this.dispose();
    }
}

