/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.dialog;

import de.gungfu.jacoto.gui.dialog.WindowClosingAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ViewerCommandDialog
extends JDialog
implements ActionListener {
    protected static Vector COMMANDS = null;
    protected JComboBox combo = null;
    protected String choice = null;
    protected boolean isChoiceNew = false;
    protected boolean canceled = false;
    protected Vector removed = new Vector();

    public ViewerCommandDialog(Frame parent, String[] commands) {
        super(parent, "ViewerCommand");
        this.addWindowListener(new WindowClosingAdapter(true));
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setLocation(new Point((int)parent.getLocation().getX() + 25, (int)parent.getLocation().getY() + 25));
        COMMANDS = new Vector();
        int i = 0;
        while (i < commands.length) {
            COMMANDS.add(commands[i]);
            ++i;
        }
        JButton button = new JButton("Ok");
        button.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 3));
        panel.add(button);
        button = new JButton("Remove");
        button.addActionListener(this);
        panel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        panel.add(button);
        this.getContentPane().add((Component)panel, "South");
        this.setModal(true);
    }

    public void show(String viewerCommand) {
        JLabel message = null;
        JPanel messagePanel = new JPanel();
        if (viewerCommand.length() > 0) {
            messagePanel.setLayout(new GridLayout(2, 1));
            messagePanel.add(new JLabel("Please specify the command to start the viewer."));
            messagePanel.add(new JLabel("Currently it is..."));
            if (COMMANDS.contains(viewerCommand)) {
                COMMANDS.remove(viewerCommand);
            }
            COMMANDS.add(0, viewerCommand);
        } else {
            message = new JLabel("Please specify command to start viewer or choose from list.");
            messagePanel.add(message);
        }
        this.getContentPane().add((Component)messagePanel, "North");
        this.combo = new JComboBox(COMMANDS);
        this.combo.setEditable(true);
        this.getContentPane().add((Component)this.combo, "Center");
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        this.canceled = false;
        if (cmd.equals("Ok")) {
            this.choice = (String)this.combo.getSelectedItem();
            if (this.choice == null || this.choice.equals("")) {
                this.message("Please select a command or press \"Cancel\".");
            } else {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        } else if (cmd.equals("Remove")) {
            this.choice = (String)this.combo.getSelectedItem();
            this.combo.removeItem(this.choice);
            this.removed.add(this.choice);
        } else if (cmd.equals("Cancel")) {
            this.canceled = true;
            ((Component)this).setVisible(false);
            this.dispose();
        }
        this.isChoiceNew = !COMMANDS.contains(this.choice);
    }

    public Vector getRemoved() {
        return this.removed;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public boolean isChoiceNew() {
        return this.isChoiceNew;
    }

    public String getChoice() {
        return this.choice;
    }

    protected void message(String message) {
        JOptionPane.showMessageDialog(this, message, "Message", 1);
    }

    protected void deb(String s) {
        System.out.println(s);
    }
}

