/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.dialog.htmlinfo;

import de.gungfu.jacoto.gui.dialog.htmlinfo.ReviewerData;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class HtmlInfoDialog
extends JDialog
implements ActionListener {
    Preferences Prefs;
    JTextField reviewerNameTF;
    private static final Dimension SIZE = new Dimension(400, 220);
    protected JRadioButton radioNone = new JRadioButton("Don't use proxy");
    protected JRadioButton radioProxy = new JRadioButton("Use these settings:");
    protected JTextField textProxyHost;
    protected JTextField textProxyPort;
    JLabel labelStatus = new JLabel("  ");
    protected static final String URL_BASE_1 = "http://gtl.jeudego.org/people/search.php3?n=";
    protected static final String URL_BASE_2 = "http://gtl.jeudego.org/people/info.php3?p_key=";
    protected static final String stringToSearch = "info.php3?p_key=";
    private JDialog dialog;

    public static void main(String[] args) {
        new HtmlInfoDialog(new Frame(), "steffen");
    }

    public HtmlInfoDialog(Frame owner, String nameOfReviewer) {
        super(owner, "Retrieve reviewer's information");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Component)HtmlInfoDialog.this).setVisible(false);
            }
        });
        this.Prefs = Preferences.getPreferences();
        JTabbedPane pane = new JTabbedPane();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel label = new JLabel("Reviewer's name:");
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.reviewerNameTF = new JTextField(nameOfReviewer);
        panel.add((Component)this.reviewerNameTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton button = new JButton("Retrieve information");
        button.addActionListener(this);
        this.getRootPane().setDefaultButton(button);
        panel.add((Component)button, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 0, new Insets(40, 20, 0, 0), 0, 0));
        button = new JButton("Cancel");
        button.addActionListener(this);
        panel.add((Component)button, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(40, 0, 0, 0), 0, 0));
        pane.addTab("Reviewer", panel);
        this.textProxyHost = new JTextField(this.Prefs.getProperty(7));
        this.textProxyPort = new JTextField(this.Prefs.getProperty(8));
        boolean useProxy = Boolean.valueOf(this.Prefs.getProperty(9));
        if (useProxy) {
            this.radioProxy.doClick();
        } else {
            this.radioNone.doClick();
            this.textProxyHost.setEnabled(false);
            this.textProxyPort.setEnabled(false);
        }
        panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.radioNone, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.radioProxy, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("Proxy Host:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.textProxyHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)new JLabel("Proxy Port:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.textProxyPort, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.labelStatus.setBorder(new BevelBorder(1));
        pane.addTab("Proxy", panel);
        this.radioNone.addActionListener(this);
        this.radioProxy.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioNone);
        buttonGroup.add(this.radioProxy);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)this.labelStatus, "South");
        ((Component)this).setSize(SIZE);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(screenSize.width / 2 - HtmlInfoDialog.SIZE.width / 2, screenSize.height / 4 - HtmlInfoDialog.SIZE.height / 4);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Retrieve information")) {
            this.startRetrievingInformation();
        } else if (cmd.equals("Cancel")) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (event.getSource() == this.radioNone) {
            this.textProxyHost.setEnabled(false);
            this.textProxyPort.setEnabled(false);
        } else if (event.getSource() == this.radioProxy) {
            this.textProxyHost.setEnabled(true);
            this.textProxyPort.setEnabled(true);
        } else if (cmd.equals("OK")) {
            this.closeInfoDialog();
        }
    }

    private void closeInfoDialog() {
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
    }

    private void startRetrievingInformation() {
        this.checkProxy();
        String reviewer = this.reviewerNameTF.getText();
        if (reviewer != null && reviewer.length() != 0) {
            String reviewerID = this.getReviewerID(this.reviewerNameTF.getText());
            if (reviewerID != null) {
                this.retrieveInformation(reviewerID);
            } else {
                this.message("This reviewer could not be found at GTL!");
            }
        }
    }

    private void checkProxy() {
        if (this.radioProxy.isSelected()) {
            ((Hashtable)System.getProperties()).put("proxySet", "true");
            ((Hashtable)System.getProperties()).put("proxyHost", this.textProxyHost.getText());
            ((Hashtable)System.getProperties()).put("proxyPort", this.textProxyPort.getText());
            this.Prefs.setProperty(9, "true");
            this.Prefs.setProperty(7, this.textProxyHost.getText());
            this.Prefs.setProperty(8, this.textProxyPort.getText());
        } else {
            ((Hashtable)System.getProperties()).put("proxySet", "false");
            this.Prefs.setProperty(9, "false");
        }
    }

    private String getSingleInfo(String buffer, int INDEX, String Info) {
        int foundIndex = buffer.indexOf(Info, INDEX);
        if (foundIndex != -1) {
            int startIndex = buffer.indexOf(">", foundIndex + Info.length());
            int endIndex = buffer.indexOf("<", startIndex);
            return buffer.substring(startIndex + 1, endIndex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void retrieveInformation(String reviewerID) {
        try {
            ReviewerData reviewer = new ReviewerData();
            URL url = new URL(URL_BASE_2 + reviewerID);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
            StringBuffer buffer = new StringBuffer();
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    void var7_8;
                    buffer.append((String)var7_8);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            String readBuffer = buffer.toString();
            int StartIndex = readBuffer.indexOf("Pseudonym:");
            reviewer.setPseudonym(this.getSingleInfo(readBuffer, StartIndex, "Pseudonym:"));
            reviewer.setRank(this.getSingleInfo(readBuffer, StartIndex, "Current&nbsp;rank:<TD>"));
            reviewer.setName(this.getSingleInfo(readBuffer, StartIndex, "Name:"));
            int fIndex = readBuffer.indexOf("mailto:", StartIndex);
            reviewer.setAddress(readBuffer.substring(fIndex + 7, readBuffer.indexOf("\">", fIndex)));
            reviewer.setStatus(this.getSingleInfo(readBuffer, StartIndex, "Status:"));
            reviewer.setDoneReviews(this.getSingleInfo(readBuffer, StartIndex, "Reviews&nbsp;done:"));
            reviewer.setInfo(this.getSingleInfo(readBuffer, StartIndex, "Info:"));
            reviewer.setRank(reviewer.getRank().replace('/', ' '));
            this.extractRank(reviewer);
            this.openDialog(reviewer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void extractRank(ReviewerData reviewer) {
        StringTokenizer token = new StringTokenizer(reviewer.getRank(), "&nbsp;", false);
        String rank = new String();
        String[] rankA = new String[4];
        String[] ranks = new String[]{"IGS: ", "NNGS: "};
        int index = 0;
        while (token.hasMoreTokens()) {
            rankA[index++] = token.nextToken().trim();
        }
        index = 0;
        while (index < 2) {
            if (rankA[index].length() > 0) {
                rank = rank + ranks[index] + rankA[index] + " ";
            }
            ++index;
        }
        if (rankA[2] != null && rankA[2].length() > 0) {
            rank = rank + rankA[3] + ": " + rankA[2];
        }
        reviewer.setRank(rank);
    }

    private void openDialog(ReviewerData reviewer) {
        this.dialog = new JDialog((Dialog)this, "Informations on reviewer " + reviewer.getPseudonym());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Pseudonym");
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JTextField text = new JTextField(reviewer.getPseudonym());
        text.setEnabled(false);
        panel.add((Component)text, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Name");
        panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        text = new JTextField(reviewer.getName());
        text.setEnabled(false);
        panel.add((Component)text, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Address");
        panel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        text = new JTextField(reviewer.getAddress());
        text.setEnabled(false);
        panel.add((Component)text, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Rank");
        panel.add((Component)label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        text = new JTextField(reviewer.getRank());
        text.setEnabled(false);
        panel.add((Component)text, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Reviews done");
        panel.add((Component)label, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        text = new JTextField(reviewer.getDoneReviews());
        text.setEnabled(false);
        panel.add((Component)text, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Status");
        panel.add((Component)label, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        text = new JTextField(reviewer.getStatus());
        text.setEnabled(false);
        panel.add((Component)text, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Info");
        panel.add((Component)label, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        text = new JTextField(reviewer.getInfo());
        text.setEnabled(false);
        panel.add((Component)text, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.dialog.getContentPane().add((Component)panel, "Center");
        JButton button = new JButton("OK");
        button.addActionListener(this);
        this.dialog.getContentPane().add((Component)button, "South");
        this.dialog.getRootPane().setDefaultButton(button);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this.dialog).setLocation(screenSize.width / 2 - HtmlInfoDialog.SIZE.width / 2 + 35, screenSize.height / 4 - HtmlInfoDialog.SIZE.height / 4 - 30);
        this.dialog.pack();
        ((Component)this.dialog).setVisible(true);
    }

    private String getReviewerID(String reviewer) {
        try {
            String line;
            URL url = new URL(URL_BASE_1 + reviewer);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
            while ((line = bufferedReader.readLine()).indexOf(stringToSearch) == -1) {
            }
            int foundIndex = line.indexOf(stringToSearch);
            if (foundIndex != -1) {
                int quotIndex = line.indexOf("\"", foundIndex);
                int counter = 1;
                while (Character.isDigit(line.charAt(quotIndex - counter))) {
                    ++counter;
                }
                return line.substring(quotIndex - counter + 1, quotIndex);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void message(String message) {
        JOptionPane.showMessageDialog(this, message, "Problem encountered!", 1);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 82) {
            this.startRetrievingInformation();
        }
    }
}

