/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.menu;

import de.gungfu.auxiliary.shortcuts.ShortcutListener;
import de.gungfu.jacoto.Jacoto;
import de.gungfu.jacoto.logic.FileInfoTableModel;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class MainMenu
extends JMenuBar {
    private Preferences _prefs;
    public static final String SORT_ENDING = "Sort";
    protected String[] standartShownInfoHeader;
    protected ShortcutListener shortcutListener = new ShortcutListener();
    public static final String EDIT_COMMENTS_MENU_TEXT = "edit comments with editor";
    public static final String COLLECTIONS_MENU_TEXT = "look for collections";
    public static final String SPLASHSCREEN_MENU_TEXT = "show Splashscreen on startup";
    public static final String DYN_SHORTCUTS_MENU_TEXT = "use dynamic shortcuts";
    public static final String RECURSIVE_ADD_MENU_TEXT = "recurse into subdirectories on drop";
    public static final String DEVIL_DRAGDROP_MENU_TEXT = "devil with Drag&Drop-ability";
    public static final String Sort_1 = "Sort";
    public static final String FILE__MENU = "File";
    public static final String FILE_NEW = "&New";
    public static final String FILE_LOAD = "L&oad";
    public static final String FILE_SAVE = "&Save";
    public static final String FILE_SAVEAS = "SaveAs";
    public static final String FILE_EXPORT = "Export";
    public static final String FILE_EXIT = "E&xit";
    public static final String EDITTABLE__MENU = "Edit Table";
    public static final String EDITTABLE_ADD = "A&dd";
    public static final String EDITTABLE_ADD_DIR = "Add all &in RecordsDirectory";
    public static final String EDITTABLE_ADD_DIR_BELOW = "Add all in RecordsDirectory and below";
    public static final String EDITTABLE_REMOVE = "&Remove";
    public static final String VIEW__MENU = "View";
    public static final String VIEW_SETSORTING = "SetSorting";
    public static final String VIEW_SETSHOWNINFOS = "SetShownInfos";
    public static final String VIEW_SORT = "Sort";
    public static final String VIEW_IN_VIEWER = "in &Viewer";
    public static final String SEARCH__MENU = "Search";
    public static final String SEARCH_PLAYER = "Search &player";
    public static final String SEARCH_PLAYER_SELECTED = "Search selected pla&yer";
    public static final String SEARCH_NEXT = "Next";
    public static final String SEARCH_AGAIN = "Again";
    public static final String STATISTICS__MENU = "Statistics";
    public static final String STATISTICS_ONE_PLAYER = "for one player";
    public static final String STATISTICS_OP_HISTORY = "&history";
    public static final String STATISTICS_OP_RANK = "rank develop&ment";
    public static final String STATISTICS_OP_COLOR = "statistics by color played";
    public static final String STATISTICS_OP_RESULTS = "won/lost/jigo";
    public static final String STATISTICS_FOR_ALL_PLAYER = "for all player";
    public static final String STATISTICS_FOP_PBLACK = "playing black";
    public static final String STATISTICS_FOP_PWHITE = "playing white";
    public static final String STATISTICS_FOP_LIST = "list of all player";
    public static final String STATISTICS_FOP_BEST = "best player";
    public static final String STATISTICS_FOP_BEST10 = "10 best player";
    public static final String STATISTICS_FOP_COMMON = "10 most common results";
    public static final String SETTINGS__MENU = "Settings";
    public static final String SETTINGS_VIEWER_LOCATION = "ViewerLocation";
    public static final String SETTINGS_VIEWER_COMMAND = "ViewerCommand";
    public static final String SETTINGS_RECORDS_DIR = "RecordsDirectory";
    public static final String SETTINGS_SAVE_SETTINGS = "save settings";
    public static final String HELP__MENU = "Help";
    public static final String HELP_WHAT = "What?";
    public static final String HELP_EXPORT = "exporting table as text-file";
    public static final String HELP_SEL_DIR = "selecting a directory";
    public static final String HELP_VIEWER = "envoking external viewer";
    public static final String HELP_COLLECTIONS = "using collections";
    public static final String HELP_MGT_FILES = "displaying MGT-files";
    public static final String HELP_SEARCH_TABLE = "searching the table";
    public static final String HELP_10BEST_STATS = "how the \"10 best players\"-statistic gets calculated";
    public static final String HELP_DYNAMIC_SHORTCUTS = "dynamic shortcuts?";
    public static final String HELP_ABOUT = "about Jacoto";
    public static final String SHORTCUT_MARKER_IN_ENTRY = "&";

    public MainMenu(ActionListener aListener, ItemListener iListener, String[] infoHeader, String sorting) {
        this._prefs = Preferences.getPreferences();
        ((Jacoto)iListener).setItemListenerStateActive(false);
        this.standartShownInfoHeader = infoHeader;
        JMenu m = new JMenu(FILE__MENU);
        this.addNew(m, FILE_NEW, aListener);
        this.addNew(m, FILE_LOAD, aListener);
        this.addNew(m, FILE_SAVE, aListener);
        this.addNew(m, FILE_SAVEAS, aListener);
        m.addSeparator();
        this.addNew(m, FILE_EXPORT, aListener);
        this.add(m);
        m = new JMenu(EDITTABLE__MENU);
        this.addNew(m, EDITTABLE_ADD, aListener);
        this.addNew(m, EDITTABLE_ADD_DIR, aListener);
        this.addNew(m, EDITTABLE_ADD_DIR_BELOW, aListener);
        this.addNew(m, EDITTABLE_REMOVE, aListener);
        this.add(m);
        m = new JMenu(VIEW__MENU);
        ButtonGroup group = new ButtonGroup();
        JMenu ms = new JMenu(VIEW_SETSORTING);
        int i = 0;
        while (i < FileInfoTableModel.ALL_HEADINGS.length) {
            this.addNewRadio(ms, group, FileInfoTableModel.ALL_HEADINGS[i] + "Sort", iListener, FileInfoTableModel.ALL_HEADINGS[i].equals(sorting));
            ++i;
        }
        ms.addActionListener(aListener);
        m.add(ms);
        ms = new JMenu(VIEW_SETSHOWNINFOS);
        List<String> L = Arrays.asList(this.standartShownInfoHeader);
        int i2 = 0;
        while (i2 < FileInfoTableModel.ALL_HEADINGS.length) {
            this.addNewCheck(ms, FileInfoTableModel.ALL_HEADINGS[i2], iListener, L.contains(FileInfoTableModel.ALL_HEADINGS[i2]));
            ++i2;
        }
        ms.addActionListener(aListener);
        m.add(ms);
        m.addSeparator();
        this.addNew(m, "Sort", aListener);
        m.addSeparator();
        this.addNew(m, VIEW_IN_VIEWER, aListener);
        this.add(m);
        m = new JMenu(SEARCH__MENU);
        this.addNew(m, SEARCH_PLAYER, aListener);
        this.addNew(m, SEARCH_PLAYER_SELECTED, aListener);
        m.addSeparator();
        this.addNew(m, SEARCH_NEXT, aListener);
        this.addNew(m, SEARCH_AGAIN, aListener);
        this.add(m);
        m = new JMenu(STATISTICS__MENU);
        ms = new JMenu(STATISTICS_ONE_PLAYER);
        this.addNew(ms, STATISTICS_OP_HISTORY, aListener);
        this.addNew(ms, STATISTICS_OP_RANK, aListener);
        this.addNew(ms, STATISTICS_OP_COLOR, aListener);
        this.addNew(ms, STATISTICS_OP_RESULTS, aListener);
        m.add(ms);
        ms = new JMenu(STATISTICS_FOR_ALL_PLAYER);
        this.addNew(ms, STATISTICS_FOP_PBLACK, aListener);
        this.addNew(ms, STATISTICS_FOP_PWHITE, aListener);
        ms.addSeparator();
        this.addNew(ms, STATISTICS_FOP_LIST, aListener);
        this.addNew(ms, STATISTICS_FOP_BEST, aListener);
        this.addNew(ms, STATISTICS_FOP_BEST10, aListener);
        this.addNew(ms, STATISTICS_FOP_COMMON, aListener);
        m.add(ms);
        this.add(m);
        m = new JMenu(SETTINGS__MENU);
        this.addNew(m, SETTINGS_VIEWER_LOCATION, aListener);
        if (System.getProperty("mrj.version") == null) {
            this.addNew(m, SETTINGS_VIEWER_COMMAND, aListener);
        }
        this.addNew(m, SETTINGS_RECORDS_DIR, aListener);
        boolean jcmState = Boolean.valueOf(this._prefs.getProperty(10));
        this.addNewCheck(m, COLLECTIONS_MENU_TEXT, iListener, jcmState, 67);
        jcmState = Boolean.valueOf(this._prefs.getProperty(6));
        this.addNewCheck(m, EDIT_COMMENTS_MENU_TEXT, iListener, jcmState, 69);
        jcmState = Boolean.valueOf(this._prefs.getProperty(5));
        this.addNewCheck(m, SPLASHSCREEN_MENU_TEXT, iListener, jcmState);
        jcmState = Boolean.valueOf(this._prefs.getProperty(20));
        this.addNewCheck(m, DYN_SHORTCUTS_MENU_TEXT, iListener, jcmState);
        jcmState = Boolean.valueOf(this._prefs.getProperty(18));
        this.addNewCheck(m, RECURSIVE_ADD_MENU_TEXT, iListener, jcmState);
        jcmState = Boolean.valueOf(this._prefs.getProperty(24));
        this.addNewCheck(m, DEVIL_DRAGDROP_MENU_TEXT, iListener, jcmState);
        m.addSeparator();
        this.addNew(m, SETTINGS_SAVE_SETTINGS, aListener);
        this.add(m);
        m = new JMenu(HELP__MENU);
        this.addNew(m, HELP_WHAT, aListener);
        m.addSeparator();
        this.addNew(m, HELP_EXPORT, aListener);
        this.addNew(m, HELP_SEL_DIR, aListener);
        this.addNew(m, HELP_VIEWER, aListener);
        this.addNew(m, HELP_COLLECTIONS, aListener);
        this.addNew(m, HELP_MGT_FILES, aListener);
        this.addNew(m, HELP_SEARCH_TABLE, aListener);
        this.addNew(m, HELP_10BEST_STATS, aListener);
        this.addNew(m, HELP_DYNAMIC_SHORTCUTS, aListener);
        m.addSeparator();
        this.addNew(m, HELP_ABOUT, aListener);
        this.add(m);
        ((Jacoto)iListener).setItemListenerStateActive(true);
    }

    protected void addNewRadio(JMenu m, ButtonGroup group, String label, ItemListener listener, boolean selected) {
        JRadioButtonMenuItem jrm = new JRadioButtonMenuItem(label);
        jrm.addItemListener(listener);
        jrm.setSelected(selected);
        group.add(jrm);
        m.add(jrm);
    }

    protected void addNewCheck(JMenu m, String label, ItemListener listener, boolean initialState) {
        this.addNewCheck(m, label, listener, initialState, -1);
    }

    protected void addNewCheck(JMenu m, String label, ItemListener listener, boolean initialState, int acceleratorKey) {
        if (System.getProperty("mrj.version") != null) {
            String RADIO_ICON_KEY = "RadioButtonMenuItem.checkIcon";
            String CHECK_ICON_KEY = "CheckBoxMenuItem.checkIcon";
            Object radioIcon = UIManager.get(RADIO_ICON_KEY);
            UIManager.put(RADIO_ICON_KEY, UIManager.get(CHECK_ICON_KEY));
            JRadioButtonMenuItem jcm = new JRadioButtonMenuItem(label, initialState);
            jcm.addItemListener(listener);
            if (acceleratorKey >= 0) {
                jcm.setAccelerator(KeyStroke.getKeyStroke(acceleratorKey, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            m.add(jcm);
            UIManager.put(RADIO_ICON_KEY, radioIcon);
        } else {
            JCheckBoxMenuItem jcm = new JCheckBoxMenuItem(label);
            jcm.setState(initialState);
            jcm.addItemListener(listener);
            if (acceleratorKey >= 0) {
                jcm.setAccelerator(KeyStroke.getKeyStroke(acceleratorKey, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            m.add(jcm);
        }
    }

    protected void addNew(JMenu m, String label, ActionListener listener) {
        int index = label.indexOf(SHORTCUT_MARKER_IN_ENTRY);
        boolean useDynShortcuts = Boolean.valueOf(this._prefs.getProperty(20));
        if (label.equals(SEARCH_NEXT)) {
            JMenuItem mi = new JMenuItem(label);
            mi.addMenuKeyListener(this.shortcutListener);
            if (!useDynShortcuts) {
                mi.setAccelerator(KeyStroke.getKeyStroke(114, 0));
            } else {
                mi.setAccelerator(this._prefs.getKeyStrokeForMenuItemByText(label));
            }
            mi.addActionListener(listener);
            m.add(mi);
        } else {
            if (index >= 0) {
                label = new StringBuffer(label).deleteCharAt(index).toString();
            }
            JMenuItem mi = new JMenuItem(label);
            mi.addMenuKeyListener(this.shortcutListener);
            if (index >= 0 && !useDynShortcuts) {
                mi.setAccelerator(KeyStroke.getKeyStroke((int)label.toUpperCase().charAt(index), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            } else if (useDynShortcuts) {
                mi.setAccelerator(this._prefs.getKeyStrokeForMenuItemByText(label));
            }
            mi.addActionListener(listener);
            m.add(mi);
        }
    }
}

