/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.menu;

import de.gungfu.auxiliary.StringExtension;
import de.gungfu.jacoto.gui.auxiliary.PopupListener;
import de.gungfu.jacoto.logic.FileInfoTableModel;
import de.gungfu.jacoto.logic.auxiliary.PointJ;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class TablePopupListener
extends PopupListener {
    private FileInfoTableModel _fit;
    private int _currentColumn;
    private int _currentRow;
    private long _currentWhen;
    public static final String INFO_REVIEWER = "Info on reviewer";
    public static final String SEARCH_REVIEWER = "Search reviewer";
    public static final String SEARCH_SELECTED_REVIEWER = "Search selected reviewer";
    public static final String SEARCH_COMMENTS = "Search in comments";
    public static final String MARK_VIEWED = "mark viewed";
    public static final String MARK_UNVIEWED = "mark unviewed";
    public static final String COUNT_RECORDS = "Count Records";

    public TablePopupListener(ActionListener listener, FileInfoTableModel fit) {
        this._popup = new JPopupMenu();
        this._listener = listener;
        this._fit = fit;
    }

    protected void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.clear();
            JTable source = (JTable)e.getSource();
            this._currentRow = source.rowAtPoint(e.getPoint());
            this._currentColumn = source.columnAtPoint(e.getPoint());
            this._currentWhen = e.getWhen();
            String columnName = this._fit.getColumnName(this._currentColumn);
            if (columnName.equals("Reviewer")) {
                this.initReviewer();
            } else if (columnName.equals("Comment")) {
                this.initComment();
            } else {
                this.initNames();
            }
            Dimension position = this.calculatePopupPosition(e);
            this._popup.show(e.getComponent(), position.width, position.height);
        }
    }

    public long getWhen() {
        return this._currentWhen;
    }

    public PointJ getWhere() {
        return new PointJ(this._currentColumn, this._currentRow);
    }

    private void initReviewer() {
        this.addStandardTopPopup();
        JMenuItem menuItem = new JMenuItem(INFO_REVIEWER);
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        this._popup.addSeparator();
        menuItem = new JMenuItem(SEARCH_REVIEWER);
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        menuItem = new JMenuItem(SEARCH_SELECTED_REVIEWER);
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        this.addStandardBottomPopup();
    }

    private void initComment() {
        this.addStandardTopPopup();
        JMenuItem menuItem = new JMenuItem(SEARCH_COMMENTS);
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        this.addStandardBottomPopup();
    }

    private void initNames() {
        this.addStandardTopPopup();
        JMenuItem menuItem = new JMenuItem(StringExtension.removeShortcutMarkerFromMenuEntry("Search &player"));
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        menuItem = new JMenuItem(StringExtension.removeShortcutMarkerFromMenuEntry("Search selected pla&yer"));
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        this.addStandardBottomPopup();
    }

    private void addStandardTopPopup() {
        JMenuItem menuItem = new JMenuItem(StringExtension.removeShortcutMarkerFromMenuEntry("&Remove"));
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        this._popup.addSeparator();
        menuItem = new JMenuItem(MARK_VIEWED);
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        menuItem = new JMenuItem(MARK_UNVIEWED);
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
        this._popup.addSeparator();
    }

    private void addStandardBottomPopup() {
        this._popup.addSeparator();
        JMenuItem menuItem = new JMenuItem(COUNT_RECORDS);
        menuItem.addActionListener(this._listener);
        this._popup.add(menuItem);
    }
}

