/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.playlist;

import de.gungfu.jacoto.gui.playlist.Jukebox;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PlaylistModel
extends AbstractTableModel {
    private static final double DATA_VECTOR_LOADFACTOR = 1.5;
    private Vector _data;
    private Hashtable _idToFilenameMapper;
    private Jukebox _jukebox;

    public PlaylistModel(Jukebox box) {
        this(new Vector(), box);
    }

    public PlaylistModel(Vector data, Jukebox box) {
        this._jukebox = box;
        this._idToFilenameMapper = new Hashtable();
        this._data = new Vector((int)((double)data.size() * 1.5));
        Iterator iter = ((AbstractList)data).iterator();
        while (iter.hasNext()) {
            this.addElement((String)iter.next());
        }
    }

    public int findRowIndexByID(String id) {
        int index = 0;
        Iterator iter = ((AbstractList)this._data).iterator();
        while (iter.hasNext()) {
            String element = PlaylistModel.extractUserfriendlyNameFromFilename((String)iter.next());
            if (element.equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Iterator getFilenames() {
        return ((AbstractList)this._data).iterator();
    }

    public boolean containsID(String id) {
        return this._idToFilenameMapper.containsKey(id);
    }

    public boolean addElement(String element) {
        if (this.isContainedAsID(element)) {
            return false;
        }
        int index = this._data.size();
        this._data.add(element);
        this.fireTableRowsInserted(index, index);
        this._idToFilenameMapper.put(PlaylistModel.extractUserfriendlyNameFromFilename(element), element);
        return true;
    }

    public void removeByFilename(String filename) {
        this._idToFilenameMapper.remove(PlaylistModel.extractUserfriendlyNameFromFilename(filename));
        int index = this._data.indexOf(filename);
        if (index < 0) {
            System.out.println("PlaylistModel.removeBF: could not remove file!");
        } else {
            this._data.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void replace(String oldID, String newFilename) {
        String oldFilename = (String)this._idToFilenameMapper.get(oldID);
        this._idToFilenameMapper.remove(oldID);
        this._idToFilenameMapper.put(PlaylistModel.extractUserfriendlyNameFromFilename(newFilename), newFilename);
        int oldIndex = this._data.indexOf(oldFilename);
        this._data.remove(oldIndex);
        this._data.insertElementAt(newFilename, oldIndex);
        this.fireTableCellUpdated(oldIndex, 0);
    }

    public boolean isContainedAsID(String filename) {
        return this._idToFilenameMapper.containsKey(PlaylistModel.extractUserfriendlyNameFromFilename(filename));
    }

    public String getCorrespondingFilename(String id) {
        return (String)this._idToFilenameMapper.get(id);
    }

    public String getCorrespondingFilenameByIndex(int index) {
        return (String)this._data.get(index);
    }

    public String getCorrespondingIDByIndex(int index) {
        return PlaylistModel.extractUserfriendlyNameFromFilename((String)this._data.get(index));
    }

    public int getSize() {
        return this._data.size();
    }

    public Object getElementAt(int index) {
        return PlaylistModel.extractUserfriendlyNameFromFilename((String)this._data.elementAt(index));
    }

    public static String extractUserfriendlyNameFromFilename(String filename) {
        int indexDir = filename.lastIndexOf(92) + 1;
        int indexExt = filename.lastIndexOf(46);
        if (indexExt > 0) {
            return filename.substring(indexDir, indexExt);
        }
        return filename.substring(indexDir);
    }

    public String getFilenameMatchingIndex(int index) {
        return (String)this._data.elementAt(index);
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this._data.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return PlaylistModel.extractUserfriendlyNameFromFilename((String)this._data.get(rowIndex));
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this._jukebox.renameFITInPlaylist(rowIndex, (String)aValue);
        super.setValueAt(aValue, rowIndex, columnIndex);
    }
}

