/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.gui.table;

import de.gungfu.auxiliary.StringExtension;
import de.gungfu.jacoto.gui.auxiliary.CellRenderer;
import de.gungfu.jacoto.logic.FileInfoTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class JacotoTableCellRenderer
implements TableCellRenderer,
CellRenderer {
    protected FileInfoTableModel fit;

    public JacotoTableCellRenderer(FileInfoTableModel fit) {
        this.fit = fit;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = new JLabel((String)value);
        label.setOpaque(true);
        Border b = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        label.setBorder(b);
        label.setFont(table.getFont());
        label.setForeground(table.getForeground());
        label.setBackground(table.getBackground());
        if (hasFocus) {
            label.setBackground(CellRenderer.DARK_BLUE);
            label.setForeground(Color.white);
        } else if (isSelected) {
            label.setBackground(CellRenderer.LIGHT_BLUE);
        } else if (this.fit.wasViewed(row)) {
            label.setBackground(CellRenderer.COLOR_VIEWED_ROWS);
        }
        if (this.fit.getNumberShownInfos() == column + 1 && this.fit.getShownInfos()[column].equals("COM")) {
            label.setToolTipText(this.generateHTMLforMultilineTooltip(this.fit.getFileInfoComment(row)));
        }
        return label;
    }

    private String generateHTMLforMultilineTooltip(String comment) {
        return "<html>" + StringExtension.replaceAll("comment", "\n", "<br>") + "</html>";
    }
}

