/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.listener;

import de.gungfu.auxiliary.StringExtension;
import de.gungfu.jacoto.Jacoto;
import de.gungfu.jacoto.auxiliary.StatisticsViewer;
import de.gungfu.jacoto.auxiliary.TableSearcher;
import de.gungfu.jacoto.gui.auxiliary.Help;
import de.gungfu.jacoto.gui.auxiliary.MessageDialogs;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class JacotoActionListener
implements ActionListener {
    private Jacoto _jac;
    private MessageDialogs _messages;
    private TableSearcher _searcher;
    private StatisticsViewer _stats;

    public JacotoActionListener(Jacoto jac, StatisticsViewer stats) {
        this._jac = jac;
        this._messages = this._jac.getMessages();
        this._searcher = this._jac.getTableSearcher();
        this._stats = stats;
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("E&xit"))) {
            this._jac.close();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("&New"))) {
            this._jac.addEmptyFITToPlaylist();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("L&oad"))) {
            this._jac.addExistingFITToPlaylist();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("&Save"))) {
            this._jac.store();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("SaveAs"))) {
            this._jac.storeAs();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Export"))) {
            this._jac.export();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("A&dd"))) {
            this.devilDragDropMessage("You can also use drag&drop to add files.\nSimply drag the file(s) from the filesystem-viewer/explorer into Jacoto.");
            this._jac.add();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Add all &in RecordsDirectory"))) {
            this.devilDragDropMessage("You can also use drag&drop to add directories.\nSimply drag the direcotries(s) from your filesystem-viewer/explorer into Jacoto.");
            this._jac.addAll();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Add all in RecordsDirectory and below"))) {
            this._jac.addAllBelow();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("&Remove"))) {
            this._jac.removeSelectedRow();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Sort"))) {
            this._jac.sort();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Count Records"))) {
            int counted = this._jac.getFIT().getSize();
            if (counted == 0) {
                this._messages.message("There's no record in this table! ;-)");
            } else if (counted == 1) {
                this._messages.message("There is one record in this table.");
            } else {
                this._messages.message("There are " + counted + " records in this table.");
            }
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("in &Viewer"))) {
            this._jac.startSelectedRecordInViewer();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("mark viewed"))) {
            this._jac.markViewed();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("mark unviewed"))) {
            this._jac.markUnviewed();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("ViewerLocation"))) {
            this._jac.viewerLocationDialog();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("ViewerCommand"))) {
            this._jac.viewerCommandsDialog();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("RecordsDirectory"))) {
            this.devilDragDropMessage("You can also use drag&drop to add directories.\nSimply drag the direcotries(s) from your filesystem-viewer/explorer into Jacoto.");
            this._jac.recordsDirectoryDialog();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Search &player"))) {
            this._searcher.searchPlayer();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Search selected pla&yer"))) {
            this._searcher.searchSelected();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Next"))) {
            this._searcher.searchNext();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Again"))) {
            this._searcher.searchAgain();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("&history"))) {
            this._stats.history();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("rank develop&ment"))) {
            this._stats.rankDev();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("statistics by color played"))) {
            this._stats.statCP();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("won/lost/jigo"))) {
            this._stats.statWLJ();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("playing black"))) {
            this._stats.statPB();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("playing white"))) {
            this._stats.statPW();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("list of all player"))) {
            this._stats.listAP();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("best player"))) {
            this._stats.listBP();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("10 best player"))) {
            this._stats.list10BP();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("10 most common results"))) {
            this._stats.list10MCR();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("save settings"))) {
            this._jac.saveSets();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("What?"))) {
            this._messages.message(Help.what);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("exporting table as text-file"))) {
            this._messages.message(Help.exports);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("using collections"))) {
            this._messages.message(Help.collections);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("selecting a directory"))) {
            this._messages.message(Help.directory);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("envoking external viewer"))) {
            this._messages.message(Help.viewer);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("displaying MGT-files"))) {
            this._messages.message(Help.mgt);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("searching the table"))) {
            this._messages.message(Help.search);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("how the \"10 best players\"-statistic gets calculated"))) {
            this._messages.message(Help.tenBest);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("dynamic shortcuts?"))) {
            this._messages.message(Help.dynShortcuts);
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("about Jacoto"))) {
            this._jac.versionDialog();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Info on reviewer"))) {
            this._jac.reviewerInfo();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Search reviewer"))) {
            this._searcher.searchReviewer();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Search selected reviewer"))) {
            this._searcher.searchSelectedReviewer();
        } else if (cmd.equals(StringExtension.removeShortcutMarkerFromMenuEntry("Search in comments"))) {
            this._searcher.searchComments();
        }
    }

    private void devilDragDropMessage(String message) {
        if (Boolean.valueOf(Preferences.getPreferences().getProperty(24)).booleanValue()) {
            this._messages.message(message + "\n\nYou can turn this notification off via\n" + "\tSettings -> " + "devil with Drag&Drop-ability" + ".");
        }
    }
}

