/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic;

import java.io.Serializable;

public class FileInfo
implements Serializable {
    private String _fileName;
    private String _fileType;
    private String _fileDirectory;
    private String _fileLocation;
    private String _gameName;
    private String _date;
    private String _nameBlack;
    private String _nameWhite;
    private String _rankBlack;
    private String _rankWhite;
    private String _result;
    private String _size;
    private String _time;
    private String _komi;
    private String _handicap;
    private String _reviewer = "";
    private String _comment = "";
    private boolean _viewed;

    public FileInfo(String filename, String content) {
        this._fileLocation = filename;
        this.setFileProps(filename);
        this._viewed = false;
        this.readFileInformation(content);
    }

    public FileInfo(String filename, String content, String comment, boolean viewed) {
        this(filename, content);
        this._viewed = viewed;
        this._comment = comment != null ? comment : "";
    }

    private void readFileInformation(String content) {
        int sgf = this._fileType.indexOf("sgf");
        int mgt = this._fileType.indexOf("mgt");
        int xml = this._fileType.indexOf("xml");
        if (sgf >= 0 || mgt >= 0) {
            this.readSGFInfo(content);
        } else if (xml >= 0) {
            this.readXMLInfo();
        } else {
            System.out.println("Falscher Dateientyp in FileInfo.readFileInformation(): " + this._fileType);
        }
    }

    private void readXMLInfo() {
    }

    private void readSGFInfo(String content) {
        String firstLines = content;
        this._gameName = this.getSingleSGF("GN", firstLines);
        this._date = this.getSingleSGF("DT", firstLines);
        this._nameBlack = this.getSingleSGF("PB", firstLines);
        this._nameWhite = this.getSingleSGF("PW", firstLines);
        this._rankBlack = this.getSingleSGF("BR", firstLines);
        this._rankWhite = this.getSingleSGF("WR", firstLines);
        this._result = this.getSingleSGF("RE", firstLines);
        this._size = this.getSingleSGF("SZ", firstLines);
        this._time = this.getSingleSGF("TM", firstLines);
        this._komi = this.getSingleSGF("KM", firstLines);
        this._handicap = this.getSingleSGF("HA", firstLines);
        if (this._handicap.equals("")) {
            this._handicap = "0";
        }
        try {
            if (Character.isDigit(this._fileName.charAt(0)) && Character.isDigit(this._fileName.charAt(this._fileName.indexOf("-") - 1))) {
                String name;
                int start = this._fileName.indexOf("-");
                int end = this._fileName.indexOf("-", start + 1);
                this._reviewer = name = this._fileName.substring(start + 1, end);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private String getSingleSGF(String tag, String in) {
        String result = new String();
        int index = in.indexOf(tag + "[");
        if (index >= 0) {
            String tagStart = in.substring(index);
            int ind2 = tagStart.indexOf("]");
            if (ind2 >= 0) {
                result = tagStart.substring(3, ind2);
            } else {
                System.out.println("Der Dateibuffer (maxChars) in FileInfo.readSGFInfo() ist zu klein!");
            }
        }
        return result;
    }

    private void setFileProps(String location) {
        String fileSeparator = System.getProperty("file.separator");
        int lastFileSeparator = location.lastIndexOf(fileSeparator);
        if (lastFileSeparator < 0) {
            lastFileSeparator = 0;
        }
        if (location.startsWith("Collection:")) {
            String file = this.getFileType(location);
            this._fileType = file.substring(0, file.length() - 1);
            this._fileName = "Collection:" + location.substring(lastFileSeparator + 1);
            this._fileDirectory = location.substring(11, lastFileSeparator);
        } else {
            this._fileType = this.getFileType(location);
            this._fileName = location.substring(lastFileSeparator + 1);
            this._fileDirectory = location.substring(0, lastFileSeparator);
        }
    }

    private String getFileType(String name) {
        String extension = name.substring(name.lastIndexOf(".") + 1).toLowerCase();
        return extension;
    }

    public void mark(boolean viewed) {
        this._viewed = viewed;
    }

    public boolean wasViewed() {
        return this._viewed;
    }

    public String getGameName() {
        return this._gameName;
    }

    public String getDate() {
        return this._date;
    }

    public String getNameBlack() {
        return this._nameBlack;
    }

    public String getNameWhite() {
        return this._nameWhite;
    }

    public String getRankBlack() {
        return this._rankBlack;
    }

    public String getRankWhite() {
        return this._rankWhite;
    }

    public String getResult() {
        return this._result;
    }

    public String getSize() {
        return this._size;
    }

    public String getTime() {
        return this._time;
    }

    public String getKomi() {
        return this._komi;
    }

    public String getHandicap() {
        return this._handicap;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getFileDirectory() {
        return this._fileDirectory;
    }

    public String getFileLocation() {
        return this._fileLocation;
    }

    public String getReviewer() {
        return this._reviewer;
    }

    public void setComment(String comm) {
        this._comment = comm;
    }

    public String getComment() {
        return this._comment;
    }

    private void deb(String s) {
        System.out.println(s);
    }
}

