/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic;

import de.gungfu.auxiliary.RecursiveList;
import de.gungfu.auxiliary.Tokenizer;
import de.gungfu.jacoto.gui.dialog.htmlinfo.FileAlreadyContainedInTableException;
import de.gungfu.jacoto.logic.FileInfo;
import de.gungfu.jacoto.logic.auxiliary.Preferences;
import de.gungfu.jacoto.logic.auxiliary.RankParser;
import de.gungfu.jacoto.logic.filter.SGFnXMLFilter;
import de.gungfu.jacoto.logic.sgffilereader.SGFFileReader;
import de.gungfu.jacoto.logic.sorter.AbstractSorter;
import de.gungfu.jacoto.logic.sorter.SorterRegistry;
import de.gungfu.jacoto.logic.statistics.Statistics;
import de.gungfu.jacoto.logic.xml.JacotoXMLReader;
import de.gungfu.jacoto.logic.xml.JacotoXMLWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class FileInfoTableModel
extends AbstractTableModel {
    private static final int STANDARD_VECTOR_START_SIZE = 1000;
    private static final int STANDARD_VECTOR_INCREMENT = 500;
    private Vector _fiVec = new Vector(1000, 500);
    private Iterator _searchIterator;
    private static final int SEARCH_NAMES = 0;
    private static final int SEARCH_REVIEWER = 1;
    private static final int SEARCH_COMMENTS = 2;
    private int _lastSearchCriterion = 0;
    public static final String[] ALL_INFOS = new String[]{"FN", "GN", "DT", "PB", "BR", "PW", "WR", "RE", "SZ", "TM", "KM", "HA", "REV", "COM"};
    public static final String[] ALL_HEADINGS = new String[]{"FileName", "GameName", "Date", "Name PlayerBlack", "Rank PlayerBlack", "Name PlayerWhite", "Rank PlayerWhite", "Result", "Size", "Time", "Komi", "Handicap", "Reviewer", "Comment"};
    private int _searchedRow;
    private String _searchedName;
    private transient String _fileName;
    private boolean _savedSinceLastChange;
    private Preferences _prefs;
    private String lastInfos = new String();
    private String[] lastShownInfos;

    public FileInfoTableModel() {
        this._prefs = Preferences.getPreferences();
        this.initVariables();
    }

    private void initVariables() {
        this._fiVec = new Vector(1000, 500);
        this._searchIterator = null;
        this._lastSearchCriterion = 0;
        this._searchedRow = 0;
        this._searchedName = null;
        this._fileName = null;
        this._savedSinceLastChange = true;
    }

    public void addTableModelListener(TableModelListener tml, boolean faulty) {
        super.addTableModelListener(tml);
    }

    public boolean removeFI(int selectedRow) {
        if (selectedRow >= 0) {
            this.deleteRowFromTable(selectedRow);
            this.fireTableRowsDeleted(selectedRow, selectedRow);
            return true;
        }
        return false;
    }

    public int getRowCount() {
        return this._fiVec.size();
    }

    public int getColumnCount() {
        return this.getShownInfos().length;
    }

    public boolean isCellEditable(int row, int col) {
        return col == this.getShownInfos().length - 1 && this.getShownInfos()[this.getShownInfos().length - 1].equals("COM");
    }

    public void setValueAt(Object value, int row, int col) {
        if (!Boolean.valueOf(this._prefs.getProperty(6)).booleanValue()) {
            if (col == this.getShownInfos().length - 1 && this.getShownInfos()[this.getShownInfos().length - 1].equals("COM")) {
                this.setComment(row, (String)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public Object getValueAt(int row, int col) {
        return this.getFileInfoAsStrings(row)[col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public String getColumnName(int col) {
        return FileInfoTableModel.getHeading(this.getShownInfos()[col]);
    }

    public void replaceWith(FileInfoTableModel f) {
        this.initVariables();
        int size = f.getSize();
        int index = 0;
        while (index < size) {
            this.addFI(f.getFI(index));
            ++index;
        }
        this.markSaved();
    }

    public void markViewed(int indexOfFI) {
        this.markChanged();
        this.getFI(indexOfFI).mark(true);
        this.fireTableRowsUpdated(indexOfFI, indexOfFI);
    }

    public void markUnviewed(int indexOfFI) {
        this.markChanged();
        this.getFI(indexOfFI).mark(false);
        this.fireTableRowsUpdated(indexOfFI, indexOfFI);
    }

    public boolean wasViewed(int indexOfFI) {
        return this.getFI(indexOfFI).wasViewed();
    }

    private String[] extractShownInfos() {
        String infos = this._prefs.getProperty(11);
        if (this.lastInfos.equals(infos)) {
            return this.lastShownInfos;
        }
        Tokenizer st = new Tokenizer(infos);
        String[] shownInfos = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.indexOf(",") >= 0) {
                token = token.substring(0, token.length() - 1);
            }
            shownInfos[index] = token;
            ++index;
        }
        this.lastInfos = infos;
        this.lastShownInfos = shownInfos;
        return shownInfos;
    }

    private String compactShownInfos(String[] infos) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < infos.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(infos[i]);
            ++i;
        }
        return sb.toString();
    }

    private String getAbbreviation(String heading) {
        List<String> L = Arrays.asList(ALL_HEADINGS);
        int index = L.indexOf(heading);
        return ALL_INFOS[index];
    }

    public void setSorting(String sort) {
        this._prefs.setProperty(12, this.getAbbreviation(sort));
    }

    public void setSorting(int columnNumber) {
        this._prefs.setProperty(12, this.extractShownInfos()[columnNumber]);
    }

    public String getSorting() {
        return this._prefs.getProperty(12);
    }

    public String getSortingFull() {
        return FileInfoTableModel.getHeading(this._prefs.getProperty(12));
    }

    public boolean isInfo(String info) {
        List<String> L = Arrays.asList(ALL_HEADINGS);
        return L.contains(info);
    }

    public void setShownInfo(String info, boolean state) {
        String infoA = this.getAbbreviation(info);
        if (state) {
            this.addShownInfo(infoA);
        } else {
            this.delShownInfo(infoA);
        }
        this.fireTableStructureChanged();
    }

    private void addShownInfo(String s) {
        String[] shownInfos = this.extractShownInfos();
        List<String> L = Arrays.asList(shownInfos);
        int index = 0;
        if (!L.contains(s)) {
            String[] newSI = new String[shownInfos.length + 1];
            int in = 0;
            while (in < ALL_INFOS.length) {
                if (L.contains(ALL_INFOS[in]) || s.equals(ALL_INFOS[in])) {
                    newSI[index] = ALL_INFOS[in];
                    ++index;
                }
                ++in;
            }
            shownInfos = newSI;
        }
        this._prefs.setProperty(11, this.compactShownInfos(shownInfos));
        this.fireTableStructureChanged();
    }

    private void delShownInfo(String s) {
        String[] shownInfos = this.extractShownInfos();
        List<String> L = Arrays.asList(shownInfos);
        int index = L.indexOf(s);
        if (index >= 0) {
            int i = index;
            while (i < shownInfos.length - 1) {
                shownInfos[i] = shownInfos[i + 1];
                ++i;
            }
            shownInfos = this.reduce(shownInfos, shownInfos.length - 2);
        }
        this._prefs.setProperty(11, this.compactShownInfos(shownInfos));
    }

    public int getNumberShownInfos() {
        return this.extractShownInfos().length;
    }

    public String[] getShownInfos() {
        return this.extractShownInfos();
    }

    public String[] getShownHeadings() {
        String[] shownInfos = this.extractShownInfos();
        String[] headings = new String[shownInfos.length];
        int i = 0;
        while (i < shownInfos.length) {
            headings[i] = FileInfoTableModel.getHeading(shownInfos[i]);
            ++i;
        }
        return headings;
    }

    public static String getHeading(int i) {
        return ALL_HEADINGS[i];
    }

    public static String getHeading(String ab) {
        List<String> L = Arrays.asList(ALL_INFOS);
        int index = L.indexOf(ab);
        return ALL_HEADINGS[index];
    }

    public String[] getFileInfoAsStrings(int obj) {
        String[] info = new String[ALL_INFOS.length + 1];
        int index = 0;
        List<String> L = Arrays.asList(this.extractShownInfos());
        FileInfo f = this.getFI(obj);
        int i = 0;
        while (i < ALL_INFOS.length) {
            if (L.contains(ALL_INFOS[i])) {
                info[index++] = this.getFileInfoPropAsString(f, ALL_INFOS[i]);
            }
            ++i;
        }
        return this.reduce(info, index);
    }

    public String getFileInfoPropAsString(FileInfo f, String prop) throws NullPointerException {
        String ret = new String();
        if (prop.equals("FN")) {
            ret = f.getFileName();
        } else if (prop.equals("GN")) {
            ret = f.getGameName();
        } else if (prop.equals("DT")) {
            ret = f.getDate();
        } else if (prop.equals("PB")) {
            ret = f.getNameBlack();
        } else if (prop.equals("BR")) {
            ret = f.getRankBlack();
        } else if (prop.equals("PW")) {
            ret = f.getNameWhite();
        } else if (prop.equals("WR")) {
            ret = f.getRankWhite();
        } else if (prop.equals("RE")) {
            ret = f.getResult();
        } else if (prop.equals("SZ")) {
            ret = f.getSize();
        } else if (prop.equals("TM")) {
            ret = f.getTime();
        } else if (prop.equals("KM")) {
            ret = f.getKomi();
        } else if (prop.equals("HA")) {
            ret = f.getHandicap();
        } else if (prop.equals("REV")) {
            ret = f.getReviewer();
        } else if (prop.equals("COM")) {
            ret = f.getComment();
        }
        return ret;
    }

    public String getFileInfoComment(int i) {
        FileInfo f = this.getFI(i);
        return f.getComment();
    }

    public String getReviewersName(int row, int column) {
        String[] shownInfos = this.extractShownInfos();
        if (column < 0 || column >= shownInfos.length || !shownInfos[column].equals("REV")) {
            return null;
        }
        return this.getFileInfoPropAsString(this.getFI(row), "REV");
    }

    public int search(int row, int column) {
        String name = this.getNameOfPlayerByCoords(row, column);
        return this.search(name);
    }

    public int search(String name) {
        this._lastSearchCriterion = 0;
        if (name == null || name.equals("")) {
            return -1;
        }
        name = name.toLowerCase();
        boolean found = false;
        int row = 0;
        this._searchIterator = ((AbstractList)this._fiVec).iterator();
        while (!found && this._searchIterator.hasNext()) {
            FileInfo currentFI = (FileInfo)this._searchIterator.next();
            if (this.doesFIcontainNameOfPlayer(name, currentFI)) {
                found = true;
                continue;
            }
            ++row;
        }
        this._searchedRow = row;
        this._searchedName = name;
        if (row >= this.getSize()) {
            return -1;
        }
        return row;
    }

    public int searchReviewer(int row, int column) {
        String name = this.getNameOfReviewerByCoords(row, column);
        return this.searchReviewer(name);
    }

    public int searchReviewer(String name) {
        if (name == null || name.equals("")) {
            return -1;
        }
        this._lastSearchCriterion = 1;
        name = name.toLowerCase();
        boolean found = false;
        int row = 0;
        this._searchIterator = ((AbstractList)this._fiVec).iterator();
        while (!found && this._searchIterator.hasNext()) {
            FileInfo currentFI = (FileInfo)this._searchIterator.next();
            if (this.doesFIcontainNameOfReviewer(name, currentFI)) {
                found = true;
                continue;
            }
            ++row;
        }
        this._searchedRow = row;
        this._searchedName = name;
        if (row >= this.getSize()) {
            return -1;
        }
        return row;
    }

    public int searchNext() {
        String name = this._searchedName;
        int row = this._searchedRow + 1;
        boolean found = false;
        while (!found && this._searchIterator != null && this._searchIterator.hasNext()) {
            FileInfo currentFI = (FileInfo)this._searchIterator.next();
            if (this._lastSearchCriterion == 1) {
                if (this.doesFIcontainNameOfReviewer(name, currentFI)) {
                    found = true;
                    continue;
                }
                ++row;
                continue;
            }
            if (this._lastSearchCriterion == 0) {
                if (this.doesFIcontainNameOfPlayer(name, currentFI)) {
                    found = true;
                    continue;
                }
                ++row;
                continue;
            }
            if (this._lastSearchCriterion != 2) continue;
            if (this.doesFIcontainStringInComment(name, currentFI)) {
                found = true;
                continue;
            }
            ++row;
        }
        this._searchedRow = row;
        if (row >= this.getSize()) {
            return -1;
        }
        return row;
    }

    public int searchAgain() {
        if (this._lastSearchCriterion == 1) {
            return this.searchReviewer(this._searchedName);
        }
        if (this._lastSearchCriterion == 0) {
            return this.search(this._searchedName);
        }
        if (this._lastSearchCriterion == 2) {
            return this.searchComments(this._searchedName);
        }
        return -1;
    }

    public int searchComments(String string) {
        this._lastSearchCriterion = 2;
        if (string == null || string.equals("")) {
            return -1;
        }
        string = string.toLowerCase();
        boolean found = false;
        int row = 0;
        this._searchIterator = ((AbstractList)this._fiVec).iterator();
        while (!found && this._searchIterator.hasNext()) {
            FileInfo currentFI = (FileInfo)this._searchIterator.next();
            if (currentFI.getComment().indexOf(string) >= 0) {
                found = true;
                continue;
            }
            ++row;
        }
        this._searchedRow = row;
        this._searchedName = string;
        if (row >= this.getSize()) {
            return -1;
        }
        return row;
    }

    private boolean doesFIcontainNameOfPlayer(String name, FileInfo currentFI) {
        return currentFI.getNameBlack().toLowerCase().equals(name) || currentFI.getNameWhite().toLowerCase().equals(name);
    }

    private boolean doesFIcontainNameOfReviewer(String name, FileInfo currentFI) {
        return currentFI.getReviewer().toLowerCase().equals(name);
    }

    private boolean doesFIcontainStringInComment(String name, FileInfo currentFI) {
        return currentFI.getReviewer().toLowerCase().equals(name);
    }

    public boolean startViewer(int indexOfFI) {
        if (indexOfFI >= 0) {
            String file = this.getFI(indexOfFI).getFileLocation();
            boolean failure = false;
            if (file.startsWith("Collection:")) {
                StringBuffer file_help = new StringBuffer(file);
                file_help.delete(0, 11);
                int index = Integer.parseInt(file_help.substring(file_help.length() - 1, file_help.length()));
                file_help.delete(file_help.length() - 1, file_help.length());
                file = file_help.toString();
                String content = SGFFileReader.read(file, index);
                file_help.delete(0, file.lastIndexOf(System.getProperty("file.separator")));
                file = file_help.toString();
                File F = null;
                try {
                    F = File.createTempFile(file, ".tmp");
                    F.deleteOnExit();
                }
                catch (IOException e) {
                    FileInfoTableModel.deb("Error creating temporary file.");
                    failure = true;
                }
                try {
                    new PrintWriter(new FileOutputStream(F), true).println(content);
                }
                catch (IOException e) {
                    FileInfoTableModel.deb("Error loading Collection.");
                    failure = true;
                }
                if (!failure) {
                    file = F.getAbsoluteFile().toString();
                }
            }
            Vector<String> commandVector = new Vector<String>();
            String viewerCommand = this._prefs.getProperty(15);
            String viewerLocation = this._prefs.getProperty(14);
            if (!failure) {
                String defaultApp = new String("JaGo");
                if (viewerCommand.length() <= 0) {
                    FileInfoTableModel.deb("Command to start viewer not specified.");
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                        commandVector.add("javaw");
                        commandVector.add("-cp");
                        commandVector.add("viewerLocation");
                        commandVector.add("jago.jar");
                        commandVector.add("LocalGo");
                        commandVector.add(file);
                    } else if (System.getProperty("mrj.version") != null) {
                        commandVector.add("open");
                        commandVector.add(file);
                        defaultApp = "application associated with file " + file;
                    } else {
                        commandVector.add("java");
                        commandVector.add("-cp");
                        commandVector.add("viewerLocation");
                        commandVector.add("jago.jar");
                        commandVector.add("LocalGo");
                        commandVector.add(file);
                    }
                    FileInfoTableModel.deb("Trying to use " + defaultApp);
                } else if (System.getProperty("mrj.version") != null) {
                    commandVector.add("open");
                    commandVector.add("-a");
                    commandVector.add(viewerLocation);
                    commandVector.add(file);
                } else {
                    commandVector = new Vector();
                    commandVector.add(viewerLocation);
                    commandVector.add(viewerCommand);
                    commandVector.add(file);
                }
                try {
                    Runtime.getRuntime().exec(this.extractStringArrayFromVector(commandVector));
                }
                catch (IOException e) {
                    FileInfoTableModel.deb("Error opening viewer with command:");
                    FileInfoTableModel.deb(e.getMessage());
                    failure = true;
                }
            }
            return !failure;
        }
        return false;
    }

    private String[] extractStringArrayFromVector(Vector vector) {
        String[] result = new String[vector.size()];
        int index = 0;
        while (index < vector.size()) {
            result[index] = (String)vector.get(index);
            ++index;
        }
        return result;
    }

    public void export(String file) {
        String[] shownInfos = this.extractShownInfos();
        FileOutputStream fos = null;
        if (!file.endsWith(".txt")) {
            file = file + ".txt";
        }
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            FileInfoTableModel.deb("Error in method FIT.export(): Outputfile not found.");
        }
        int[] sizeLine = new int[shownInfos.length];
        int i = 0;
        while (i < shownInfos.length) {
            sizeLine[i] = this.calcMaxLengthColumn(shownInfos[i]) + 3;
            ++i;
        }
        PrintWriter pw = new PrintWriter(fos);
        List<String> L = Arrays.asList(shownInfos);
        pw.print("#");
        int counter = 0;
        int i2 = 0;
        while (i2 < ALL_INFOS.length) {
            if (L.contains(ALL_INFOS[i2])) {
                pw.print(this.fillUp(ALL_HEADINGS[i2], sizeLine[counter]) + "#");
                ++counter;
            }
            ++i2;
        }
        pw.println();
        int i3 = 0;
        while (i3 < sizeLine.length) {
            int in = 0;
            while (in <= sizeLine[i3]) {
                pw.print("-");
                ++in;
            }
            ++i3;
        }
        pw.println();
        FileInfo f = null;
        Iterator it = ((AbstractList)this._fiVec).iterator();
        while (it.hasNext()) {
            counter = 0;
            f = (FileInfo)it.next();
            pw.print("#");
            int in = 0;
            while (in < ALL_INFOS.length) {
                if (L.contains(ALL_INFOS[in])) {
                    pw.print(this.fillUp(this.getFileInfoPropAsString(f, ALL_INFOS[in]), sizeLine[counter]));
                    pw.print("#");
                    ++counter;
                }
                ++in;
            }
            pw.println();
        }
        pw.flush();
        pw.close();
        FileInfoTableModel.deb("Finished export.");
    }

    private int calcMaxLengthColumn(String header) {
        int maxLength = FileInfoTableModel.getHeading(header).length();
        int temp = 0;
        Iterator it = ((AbstractList)this._fiVec).iterator();
        while (it.hasNext()) {
            temp = this.getFileInfoPropAsString((FileInfo)it.next(), header).length();
            if (temp <= maxLength) continue;
            maxLength = temp;
        }
        return maxLength;
    }

    public static FileInfoTableModel open(String file) {
        boolean failure = false;
        FileInfoTableModel fit = null;
        JacotoXMLReader jxr = new JacotoXMLReader();
        System.out.println("Reading table: " + file + "...");
        jxr.readAndBuildFIT(file);
        fit = jxr.getFIT();
        System.out.println("...finished with " + file);
        if (fit != null) {
            fit.setFilename(file);
            fit.markSaved();
            int sortDir = Integer.parseInt(Preferences.getPreferences().getProperty(4));
            fit.sort(sortDir);
            return fit;
        }
        return null;
    }

    public static FileInfo createFileInfo(String filename, String content, String comment, boolean viewed) {
        return new FileInfo(filename, content, comment, viewed);
    }

    public boolean save() {
        if (this._fileName == null) {
            return false;
        }
        JacotoXMLWriter jxw = new JacotoXMLWriter(this);
        if (jxw.write(this._fileName)) {
            this.markSaved();
            return true;
        }
        return false;
    }

    public void sort() {
        this.sort(0);
    }

    private void sort(int direction) {
        Object[] fiArray = this._fiVec.toArray();
        AbstractSorter sorter = this.getSorter();
        sorter.setDirection(direction);
        Arrays.sort(fiArray, sorter);
        this._prefs.setProperty(4, "" + sorter.getDirection());
        this.loadArrayIntoFIVector(fiArray);
    }

    private AbstractSorter getSorter() {
        return this.getSorter(this._prefs.getProperty(12));
    }

    private AbstractSorter getSorter(String sorting) {
        if (sorting.equals("DT")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Date);
        }
        if (sorting.equals("PB")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.NameBlack);
        }
        if (sorting.equals("PW")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.NameWhite);
        }
        if (sorting.equals("BR")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.RankBlack);
        }
        if (sorting.equals("WR")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.RankWhite);
        }
        if (sorting.equals("RE")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Result);
        }
        if (sorting.equals("GN")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.GameName);
        }
        if (sorting.equals("FN")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.FileName);
        }
        if (sorting.equals("HA")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Handicap);
        }
        if (sorting.equals("KM")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Komi);
        }
        if (sorting.equals("SZ")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Size);
        }
        if (sorting.equals("TM")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Time);
        }
        if (sorting.equals("REV")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Reviewer);
        }
        if (sorting.equals("COM")) {
            return SorterRegistry.getRegistry().getInstance(SorterRegistry.Comment);
        }
        FileInfoTableModel.deb("FileInfoTableModel.getSorter(String): This sorting has not been implemented, yet.");
        return SorterRegistry.getRegistry().getInstance(SorterRegistry.FileName);
    }

    private void loadArrayIntoFIVector(Object[] array) {
        this._fiVec = new Vector(array.length + 100, 500);
        int index = 0;
        while (index < array.length) {
            this._fiVec.add(array[index]);
            ++index;
        }
        this.fireTableDataChanged();
    }

    private int getInsertionPlace(FileInfo f) {
        Object[] fiArray = this._fiVec.toArray();
        return Arrays.binarySearch(fiArray, f, this.getSorter());
    }

    private boolean isAlreadyInTable(FileInfo fi) {
        boolean isCollectionMember;
        boolean foundOne = false;
        String location = fi.getFileLocation();
        String locCol = new String();
        boolean bl = isCollectionMember = location.endsWith("0") && location.startsWith("Collection:");
        if (isCollectionMember) {
            locCol = location.substring("Collection:".length(), location.length() - 1);
        }
        Iterator it = ((AbstractList)this._fiVec).iterator();
        while (it.hasNext() && !foundOne) {
            String ficLocation = ((FileInfo)it.next()).getFileLocation();
            if (ficLocation.endsWith("0")) {
                if (!isCollectionMember) {
                    foundOne = ficLocation.substring("Collection:".length(), ficLocation.length() - 1).equals(location);
                    continue;
                }
                foundOne = ficLocation.substring("Collection:".length(), ficLocation.length() - 1).equals(locCol);
                continue;
            }
            if (!isCollectionMember) {
                foundOne = location.equals(ficLocation);
                continue;
            }
            if (!isCollectionMember) continue;
            foundOne = locCol.equals(ficLocation);
        }
        return foundOne;
    }

    public int add(String location) throws FileAlreadyContainedInTableException {
        SGFFileReader jt = new SGFFileReader(location, this.useCollections());
        FileInfo[] f = new FileInfo[jt.size()];
        int i = 0;
        while (i < jt.size()) {
            f[i] = new FileInfo(jt.getFilename(i), jt.getContent(i));
            ++i;
        }
        if (f.length > 1) {
            int in = 0;
            int i2 = 0;
            while (i2 < f.length) {
                int where = this.addFI(f[i2]);
                if (where < 0) {
                    ++in;
                }
                ++i2;
            }
            return in;
        }
        int where = this.addFI(f[0]);
        if (where < 0) {
            throw new FileAlreadyContainedInTableException();
        }
        return -1;
    }

    public int addFI(FileInfo fi) {
        if (!this.isAlreadyInTable(fi)) {
            int where = this.getInsertionPlace(fi);
            if (where < 0) {
                where *= -1;
            } else if (where == 0) {
                ++where;
            }
            this.addAt(--where, fi);
            return where;
        }
        return -1;
    }

    public void addAt(int where, FileInfo fi) {
        this._fiVec.add(where, fi);
        this.markChanged();
        this.fireTableRowsInserted(where, where);
    }

    public int addFile(File aFile) {
        int counter = 0;
        int alreadyIn = 0;
        SGFFileReader jt = new SGFFileReader(aFile.getAbsolutePath(), this.useCollections());
        int in = 0;
        while (in < jt.size()) {
            ++counter;
            if (this.addFI(new FileInfo(jt.getFilename(in), jt.getContent(in))) < 0) {
                ++alreadyIn;
            }
            ++in;
        }
        return counter - alreadyIn;
    }

    public int addDroppedFile(File aFile) {
        SGFnXMLFilter nameFilter = new SGFnXMLFilter();
        if (aFile.isFile()) {
            if (nameFilter.accept(aFile)) {
                return this.addFile(aFile);
            }
            return 0;
        }
        if (aFile.isDirectory() && Boolean.valueOf(this._prefs.getProperty(18)).booleanValue()) {
            return this.addAllFIsBelow(aFile);
        }
        return 0;
    }

    public int addAllFIs() {
        return this.addAllFIs(new File(this._prefs.getProperty(16)));
    }

    public int addAllFIs(File aDirectory) {
        System.out.println("Adding " + aDirectory.getAbsolutePath());
        if (!aDirectory.isDirectory()) {
            FileInfoTableModel.deb("Error in method FIT.addAllFIs(). No directory specified.");
            return -1;
        }
        int Counter = 0;
        String[] names = aDirectory.list(new SGFnXMLFilter());
        String directory = aDirectory.getAbsolutePath() + System.getProperty("file.separator");
        int alreadyIn = 0;
        int i = 0;
        while (i < names.length) {
            Counter += this.addFile(new File(directory + names[i]));
            ++i;
        }
        return Counter - alreadyIn;
    }

    public int addAllFIsBelow() {
        return this.addAllFIsBelow(new File(this._prefs.getProperty(16)));
    }

    public int addAllFIsBelow(File aDirectory) {
        int count = 0;
        Vector fileList = RecursiveList.getFiles(aDirectory, new SGFnXMLFilter());
        Iterator i = ((AbstractList)fileList).iterator();
        while (i.hasNext()) {
            count += this.addFile((File)i.next());
        }
        return count;
    }

    public FileInfo getFI(int i) {
        return (FileInfo)this._fiVec.elementAt(i);
    }

    public void setComment(int index, String newComment) {
        String oldComment = this.getFI(index).getComment();
        if (!newComment.equals(oldComment)) {
            this.getFI(index).setComment(newComment);
            this.markChanged();
        }
    }

    public Vector getHistory(int row, int column) {
        String nameAux = this.getNameOfPlayerByCoords(row, column);
        if (nameAux == null) {
            return null;
        }
        String name = nameAux.toLowerCase();
        Vector<Object> history = new Vector<Object>();
        Iterator fiIt = ((AbstractList)this._fiVec).iterator();
        while (fiIt.hasNext()) {
            FileInfo f = (FileInfo)fiIt.next();
            if (!f.getNameBlack().toLowerCase().equals(name) && !f.getNameWhite().toLowerCase().equals(name)) continue;
            Vector<String> game = new Vector<String>();
            game.add(f.getDate());
            String result = null;
            if (f.getNameBlack().toLowerCase().equals(name)) {
                game.add(f.getRankBlack());
                game.add(f.getNameWhite());
                game.add(f.getRankWhite());
                result = f.getResult().toLowerCase();
                if (result.startsWith("b")) {
                    result = "Won playing black";
                } else if (result.startsWith("w")) {
                    result = "Lost playing black";
                }
            } else {
                game.add(f.getRankWhite());
                game.add(f.getNameBlack());
                game.add(f.getRankBlack());
                result = f.getResult().toLowerCase();
                if (result.startsWith("b")) {
                    result = "Lost playing white";
                } else if (result.startsWith("w")) {
                    result = "Won playing white";
                }
            }
            result = !f.getHandicap().equals("0") ? result + " with " + f.getHandicap() + " stones handicap." : result + ".";
            game.add(result);
            history.add(game);
        }
        this.sortHistory(history);
        int i = 0;
        while (i < history.size()) {
            ((Vector)history.elementAt(i)).remove(0);
            ++i;
        }
        history.add(0, name);
        return history;
    }

    public long[][] getRankDevelopment(int row, int column) {
        String nameAux = this.getNameOfPlayerByCoords(row, column);
        if (nameAux == null) {
            return null;
        }
        String name = nameAux.toLowerCase();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Vector occurances = this.getRowsWithPlayer(name);
        Date date = new Date();
        long[][] help = new long[occurances.size()][2];
        int index = 0;
        while (index < occurances.size()) {
            FileInfo f = (FileInfo)occurances.elementAt(index);
            if (f.getNameBlack().toLowerCase().equals(name)) {
                help[index][0] = RankParser.parse(f.getRankBlack());
                try {
                    date = formatter.parse(f.getDate());
                }
                catch (ParseException e) {}
            } else {
                help[index][0] = RankParser.parse(f.getRankWhite());
                try {
                    date = formatter.parse(f.getDate());
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            help[index][1] = date.getTime();
            ++index;
        }
        return help;
    }

    private Vector getRowsWithPlayer(String name) {
        Vector<FileInfo> help = new Vector<FileInfo>();
        Iterator it = ((AbstractList)this._fiVec).iterator();
        while (it.hasNext()) {
            FileInfo f = (FileInfo)it.next();
            if (!f.getNameBlack().toLowerCase().equals(name) && !f.getNameWhite().toLowerCase().equals(name)) continue;
            help.add(f);
        }
        return help;
    }

    public Vector getStatisticsOfPlayerByColor(int row, int column) {
        String nameAux = this.getNameOfPlayerByCoords(row, column);
        if (nameAux == null) {
            return null;
        }
        String name = nameAux.toLowerCase();
        Vector result = Statistics.getSinglePlayerByColor(this, name);
        result.add(0, name);
        return result;
    }

    private void sortHistory(Vector hist) {
        int i = 1;
        while (i < hist.size()) {
            Vector newGame = (Vector)hist.remove(i);
            String date = (String)newGame.elementAt(0);
            int in = i - 1;
            while (in >= 0 && date.compareTo((String)((Vector)hist.elementAt(in)).elementAt(0)) > 0) {
                --in;
            }
            hist.insertElementAt(newGame, in + 1);
            ++i;
        }
    }

    private String getNameOfPlayerByCoords(int selectedRow, int selectedColumn) {
        String infoInColumn;
        String name = null;
        if (selectedColumn >= 0 && ((infoInColumn = this.getShownInfos()[selectedColumn]).equals("PB") || infoInColumn.equals("PW"))) {
            name = this.getFileInfoAsStrings(selectedRow)[selectedColumn];
        }
        return name;
    }

    private String getNameOfReviewerByCoords(int selectedRow, int selectedColumn) {
        String infoInColumn;
        String name = null;
        if (selectedColumn >= 0 && (infoInColumn = this.getShownInfos()[selectedColumn]).equals("REV")) {
            name = this.getFileInfoAsStrings(selectedRow)[selectedColumn];
        }
        return name;
    }

    public Statistics getStatisticsPlayer(int selectedRow, int selectedColumn) {
        String name = this.getNameOfPlayerByCoords(selectedRow, selectedColumn);
        if (name != null) {
            return Statistics.getSinglePlayer(this, name);
        }
        return null;
    }

    public Statistics getStatisticsAllPlayerByColor(String color) {
        if (this.isEmptyTable()) {
            return null;
        }
        return Statistics.getAllPlayerByColor(this, color);
    }

    public Vector getStatisticsAllPlayer() {
        if (this.isEmptyTable()) {
            return null;
        }
        return Statistics.getAllPlayerRanking(this);
    }

    public Vector getStatisticsBestPlayer() {
        if (this.isEmptyTable()) {
            return null;
        }
        return Statistics.getBestPlayer(this);
    }

    public Vector getStatisticsBestPlayerRanking() {
        if (this.isEmptyTable()) {
            return null;
        }
        return Statistics.getBestPlayerRanking(this);
    }

    public Vector getStatisticsMostCommonResults() {
        if (this.isEmptyTable()) {
            return null;
        }
        return Statistics.getMostCommonResults(this);
    }

    public boolean isSavedSinceLastChange() {
        return this._savedSinceLastChange;
    }

    public void markChanged() {
        this._savedSinceLastChange = false;
    }

    public void markSaved() {
        this._savedSinceLastChange = true;
    }

    public int getSize() {
        return this._fiVec.size();
    }

    public void useCollections(boolean use) {
        this._prefs.setProperty(10, new Boolean(use).toString());
    }

    public void useEditor(boolean use) {
        this._prefs.setProperty(6, new Boolean(use).toString());
    }

    public void setViewerLocation(String location) {
        if (!location.endsWith(System.getProperty("file.separator"))) {
            location = location + System.getProperty("file.separator");
        }
        this._prefs.setProperty(14, location);
    }

    public String getViewerLocation() {
        return this._prefs.getProperty(14);
    }

    public void setViewerCommand(String cmd) {
        this._prefs.setProperty(15, cmd);
    }

    public String getViewerCommand() {
        return this._prefs.getProperty(15);
    }

    public void setRecordsDirectory(String location) {
        this._prefs.setProperty(16, location);
    }

    public void setRecordsDirectory(File location) {
        this._prefs.setProperty(16, location.getAbsolutePath());
    }

    public File getRecordsDirectory() {
        return new File(this._prefs.getProperty(16));
    }

    public void setWorkingDirectory(String location) {
        this._prefs.setProperty(17, location);
    }

    public void setWorkingDirectory(File location) {
        this._prefs.setProperty(17, location.getAbsolutePath());
    }

    public File getWorkingDirectory() {
        return new File(this._prefs.getProperty(17));
    }

    public void setFilename(String file) {
        if (!file.endsWith(".jac")) {
            file = file + ".jac";
        }
        this._fileName = file;
        this.markChanged();
    }

    public String getFilename() {
        return this._fileName;
    }

    private void deleteRowFromTable(int index) {
        this._fiVec.remove(index);
        this._savedSinceLastChange = false;
        this.fireTableRowsDeleted(index, index);
    }

    public boolean isEmptyTable() {
        return this._fiVec.size() == 0;
    }

    public boolean useCollections() {
        return Boolean.getBoolean(this._prefs.getProperty(10));
    }

    private String[] reduce(String[] start, int i) {
        String[] result = new String[i];
        int in = 0;
        while (in < i) {
            result[in] = start[in];
            ++in;
        }
        return result;
    }

    private static void deb(String s) {
        System.out.println(s);
    }

    private void print(String[] s) {
        int i = 0;
        while (i < s.length) {
            System.out.print(s[i] + " ");
            ++i;
        }
    }

    private String fillUp(String s, int to) {
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < to) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

