/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.auxiliary;

import de.gungfu.auxiliary.shortcuts.ShortcutRegistry;
import de.gungfu.jacoto.logic.NoViewerCommandSpecifiedException;
import de.gungfu.jacoto.logic.auxiliary.IntegerList;
import de.gungfu.jacoto.logic.auxiliary.PreferencesConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class Preferences
extends Properties
implements PreferencesConstants {
    private static String _Filename;
    private static File _jacotoConfigFile;
    private static final String _jacotoConfigFilename = ".jacoto.prefs";
    private static final String _OSXConfigFilename = "Library/Preferences/jacoto.prefs";
    private static Preferences _preferences;
    private final Preferences _settingsAfterLastSave;
    private IntegerList _thingsChanged;
    private static ZipEntry _entry;
    private Hashtable _icons = new Hashtable();
    private static final String _iconFilename = "/jacoto.gif";
    private static final String _whiteIcon = "/white.gif";
    private static final String _blackIcon = "/black.gif";
    private static final String _commentIcon = "/comment.gif";
    private ShortcutRegistry _shortcutReg;
    private static boolean _hasChangedSinceLastSave;
    static /* synthetic */ Class class$de$gungfu$jacoto$logic$auxiliary$Preferences;

    private Preferences() {
        this._thingsChanged = new IntegerList();
        this._icons.put("Black", new ImageIcon((class$de$gungfu$jacoto$logic$auxiliary$Preferences == null ? (class$de$gungfu$jacoto$logic$auxiliary$Preferences = Preferences.class$("de.gungfu.jacoto.logic.auxiliary.Preferences")) : class$de$gungfu$jacoto$logic$auxiliary$Preferences).getResource(_blackIcon)));
        this._icons.put("White", new ImageIcon((class$de$gungfu$jacoto$logic$auxiliary$Preferences == null ? (class$de$gungfu$jacoto$logic$auxiliary$Preferences = Preferences.class$("de.gungfu.jacoto.logic.auxiliary.Preferences")) : class$de$gungfu$jacoto$logic$auxiliary$Preferences).getResource(_whiteIcon)));
        this._icons.put("FrameIcon", new ImageIcon((class$de$gungfu$jacoto$logic$auxiliary$Preferences == null ? (class$de$gungfu$jacoto$logic$auxiliary$Preferences = Preferences.class$("de.gungfu.jacoto.logic.auxiliary.Preferences")) : class$de$gungfu$jacoto$logic$auxiliary$Preferences).getResource(_iconFilename)));
        this._icons.put("Comment", new ImageIcon((class$de$gungfu$jacoto$logic$auxiliary$Preferences == null ? (class$de$gungfu$jacoto$logic$auxiliary$Preferences = Preferences.class$("de.gungfu.jacoto.logic.auxiliary.Preferences")) : class$de$gungfu$jacoto$logic$auxiliary$Preferences).getResource(_commentIcon)));
        String dir = System.getProperty("user.home");
        _Filename = System.getProperty("mrj.version") != null ? dir + System.getProperty("file.separator") + _OSXConfigFilename : dir + System.getProperty("file.separator") + _jacotoConfigFilename;
        String working = System.getProperty("user.dir") + System.getProperty("file.separator") + "Jacoto.jar";
        _jacotoConfigFile = new File(working);
        boolean failure = false;
        _hasChangedSinceLastSave = false;
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(_Filename));
        }
        catch (IOException e) {
            failure = true;
        }
        if (!failure) {
            try {
                System.out.println("Reading preferences from '" + _Filename + "'.");
                this.load(bis);
                bis.close();
            }
            catch (IOException e) {
                System.out.println("Error reading preferences.");
            }
        } else {
            System.out.println("Error opening preferences!");
        }
        this._settingsAfterLastSave = (Preferences)((Hashtable)this).clone();
        this._shortcutReg = ShortcutRegistry.loadShortcutsFromPreferences(this._settingsAfterLastSave);
    }

    public ShortcutRegistry getShortcutRegistry() {
        return this._shortcutReg;
    }

    public KeyStroke getKeyStrokeForMenuItemByText(String identifier) {
        return this._shortcutReg.getKeyStrokeByMenuText(identifier);
    }

    public ImageIcon getImageIcon(String identifier) {
        return (ImageIcon)this._icons.get(identifier);
    }

    public static Preferences getPreferences() {
        if (_preferences == null) {
            _preferences = new Preferences();
        }
        return _preferences;
    }

    public void addThingChanged(int thing) {
        this._thingsChanged.add(thing);
    }

    public String[] getThingsChanged() {
        String[] result = new String[this._thingsChanged.size()];
        int index = 0;
        while (index < result.length) {
            result[index] = Preferences.resolveKey(this._thingsChanged.get(index));
            ++index;
        }
        return result;
    }

    public boolean[] getThingsChangedDefaultSelections() {
        boolean[] result = new boolean[this._thingsChanged.size()];
        int index = 0;
        while (index < result.length) {
            result[index] = this._thingsChanged.get(index) > 4;
            ++index;
        }
        return result;
    }

    private void emptyThingsChanged() {
        this._thingsChanged = new IntegerList();
    }

    public boolean hasChangedSinceLastSave() {
        return _hasChangedSinceLastSave;
    }

    public Object setProperty(int key, String value) {
        boolean changed = false;
        if (key != 15) {
            String former = super.getProperty(Preferences.resolveKey(key));
            if (former == null || !former.equals(value)) {
                _hasChangedSinceLastSave = true;
                super.setProperty(Preferences.resolveKey(key), value);
                changed = true;
            }
        } else {
            this.setCurrentViewerCommand(value);
            changed = true;
        }
        if (changed) {
            this.addThingChanged(key);
        }
        return new Object();
    }

    public void setPropertyShortcut(String keyString, String itemText) {
        String former = super.getProperty(keyString);
        if (former == null || !former.equals(itemText)) {
            _hasChangedSinceLastSave = true;
            super.setProperty(keyString, itemText);
            this.addThingChanged(21);
        }
    }

    public String getProperty(int key) {
        String comm;
        if (key == 15) {
            try {
                comm = this.getProperty_usedViewerCommand();
            }
            catch (NoViewerCommandSpecifiedException e) {
                comm = "";
            }
        } else {
            comm = super.getProperty(Preferences.resolveKey(key));
        }
        if (comm == null || comm.length() == 0) {
            String stdValue = this.standardValueForProperty(key);
            super.setProperty(Preferences.resolveKey(key), stdValue);
            return stdValue;
        }
        return comm;
    }

    public Vector getProperties(int key) {
        Vector<String> result = new Vector<String>();
        if (key == 25) {
            int counter = 0;
            while (super.getProperty("playlistEntry" + counter) != null) {
                result.add(super.getProperty("playlistEntry" + counter));
                ++counter;
            }
        }
        return result;
    }

    public String getProperty(String key) {
        System.out.println("getProperty using String!");
        return null;
    }

    public Object setProperty(String key, String value) {
        System.out.println("setProperty using String: " + key + " value: " + value);
        return null;
    }

    public String[] getCommandsAsArray() {
        Vector<String> result = new Vector<String>();
        int count = 0;
        while (((Hashtable)this).containsKey("viewerCommand" + count)) {
            result.add((String)((Hashtable)this).get("viewerCommand" + count));
            ++count;
        }
        return result.toArray(new String[count]);
    }

    public String getProperty_usedViewerCommand() throws NoViewerCommandSpecifiedException {
        if (((Hashtable)this).containsKey("viewerCommand0")) {
            return (String)((Hashtable)this).get("viewerCommand0");
        }
        throw new NoViewerCommandSpecifiedException();
    }

    public void removeViewerCommand(String command) {
        Vector<String> result = new Vector<String>();
        int count = 0;
        while (((Hashtable)this).containsKey("viewerCommand" + count)) {
            result.add((String)((Hashtable)this).get("viewerCommand" + count));
            ((Hashtable)this).remove("viewerCommand" + count);
            ++count;
        }
        result.remove(command);
        while (result.size() > 0) {
            String aux = (String)result.firstElement();
            super.setProperty("viewerCommand", aux);
            result.remove(aux);
        }
        _hasChangedSinceLastSave = true;
    }

    public void setCurrentViewerCommand(String command) {
        if (!command.equals((String)((Hashtable)this).get("viewerCommand0"))) {
            if (((Hashtable)this).get("viewerCommand0") == null) {
                super.setProperty("viewerCommand0", command);
            } else {
                Vector<String> result = new Vector<String>();
                int count = 0;
                while (((Hashtable)this).containsKey("viewerCommand" + count)) {
                    result.add((String)((Hashtable)this).get("viewerCommand" + count));
                    ((Hashtable)this).remove("viewerCommand" + count);
                    ++count;
                }
                result.remove(command);
                super.setProperty("viewerCommand0", command);
                int index = 0;
                while (index < result.size()) {
                    String element = (String)result.elementAt(index);
                    super.setProperty("viewerCommand" + (index + 1), element);
                    ++index;
                }
                _hasChangedSinceLastSave = true;
            }
        }
    }

    public boolean store() {
        return this.store(this);
    }

    public boolean store(Preferences prefToStore) {
        boolean failure = false;
        try {
            FileOutputStream fos = new FileOutputStream(_Filename);
            prefToStore.store(fos, "Jacoto's preferences\n#Path to Jacoto: " + System.getProperty("user.dir"));
            fos.flush();
            fos.close();
            _preferences = new Preferences();
        }
        catch (IOException e) {
            System.out.println("Failed to save preferences: " + e.getMessage());
            failure = true;
        }
        return failure;
    }

    public boolean store(Vector selectedProperties, Iterator playlistFilenames, String currentlySelected) {
        this.updatePlaylistBeforeSave(playlistFilenames, currentlySelected);
        if (selectedProperties != null) {
            this.updateSettingsBeforeSave(selectedProperties);
        }
        return this.store(this._settingsAfterLastSave);
    }

    private void updatePlaylistBeforeSave(Iterator playlistFilenames, String currentlySelected) {
        System.out.println("currentlySelected1: " + currentlySelected);
        this.cleanPreferencesFromPlaylistEntries();
        int playlistIndex = 0;
        while (playlistFilenames.hasNext()) {
            String element = (String)playlistFilenames.next();
            if (element.startsWith("EmptyTable")) continue;
            ((Hashtable)this._settingsAfterLastSave).put("playlistEntry" + playlistIndex, element);
            ++playlistIndex;
        }
        ((Hashtable)this._settingsAfterLastSave).put("activeTable", currentlySelected);
    }

    private void cleanPreferencesFromPlaylistEntries() {
        Enumeration enumeration = ((Hashtable)this._settingsAfterLastSave).keys();
        while (enumeration.hasMoreElements()) {
            String element = (String)enumeration.nextElement();
            if (!element.startsWith("playlistEntry")) continue;
            ((Hashtable)this._settingsAfterLastSave).remove(element);
        }
    }

    private void updateSettingsBeforeSave(Vector propertiesToSave) {
        this.updateShortcutsInSettingsBeforeSave(propertiesToSave);
        Iterator iter = ((AbstractList)propertiesToSave).iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            System.out.println("updateSettingsBeforeSave " + element);
            ((Hashtable)this._settingsAfterLastSave).put(element, ((Hashtable)this).get(element));
        }
    }

    private void updateShortcutsInSettingsBeforeSave(Vector properties) {
        if (!properties.contains("shortcutChanged")) {
            properties.remove("shortcutChanged");
            this.cleanPreferencesFromShortcutEntries();
            Enumeration keystrokes = this._shortcutReg.getEnumerationOverAllShortcuts();
            while (keystrokes.hasMoreElements()) {
                KeyStroke element = (KeyStroke)keystrokes.nextElement();
                ((Hashtable)this._settingsAfterLastSave).put(ShortcutRegistry.generatePreferenceEntryFromKeyStroke(element), this._shortcutReg.getText(element));
            }
        }
    }

    private void cleanPreferencesFromShortcutEntries() {
        Enumeration enumeration = ((Hashtable)this._settingsAfterLastSave).keys();
        while (enumeration.hasMoreElements()) {
            String element = (String)enumeration.nextElement();
            if (!element.startsWith("shortcut:")) continue;
            ((Hashtable)this._settingsAfterLastSave).remove(element);
        }
    }

    public String getProperty(String key, String defaultValue) {
        System.out.println("Preferences.getProperty(String, String) wird umgeleitet!");
        return this.getProperty(key);
    }

    public static String resolveKey(int key) {
        switch (key) {
            case 12: {
                return "sorting";
            }
            case 4: {
                return "sortingDirection";
            }
            case 11: {
                return "shownInfos";
            }
            case 17: {
                return "workingDirectory";
            }
            case 16: {
                return "recordsDirectory";
            }
            case 7: {
                return "proxyHost";
            }
            case 8: {
                return "proxyPort";
            }
            case 9: {
                return "proxySet";
            }
            case 0: {
                return "sizeX";
            }
            case 1: {
                return "sizeY";
            }
            case 2: {
                return "locationX";
            }
            case 3: {
                return "locationY";
            }
            case 6: {
                return "useEditorForComments";
            }
            case 10: {
                return "useCollections";
            }
            case 15: {
                return "viewerCommand";
            }
            case 5: {
                return "showSplashscreen";
            }
            case 20: {
                return "useDynamicShortcuts";
            }
            case 21: {
                return "shortcutChanged";
            }
            case 18: {
                return "recurseIntoSubdirectories";
            }
            case 22: {
                return "splitpaneDividerWidth";
            }
            case 23: {
                return "activeTable";
            }
            case 24: {
                return "devilDragDrop";
            }
            case 25: {
                return "playlistEntry";
            }
        }
        return "";
    }

    private String standardValueForProperty(int key) {
        switch (key) {
            case 12: {
                return "FN";
            }
            case 4: {
                return "-1";
            }
            case 11: {
                return "FN PB BR PW WR RE COM";
            }
            case 17: {
                return PreferencesConstants._standardWorkingDir;
            }
            case 16: {
                return PreferencesConstants._standardRecordsDir;
            }
            case 7: {
                return "192.168.0.1";
            }
            case 8: {
                return "8080";
            }
            case 9: {
                return "false";
            }
            case 0: {
                return "664";
            }
            case 1: {
                return "334";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "";
            }
            case 6: {
                return "true";
            }
            case 10: {
                return "false";
            }
            case 15: {
                return "cgoban.exe -edit ";
            }
            case 5: {
                return "true";
            }
            case 20: {
                return "false";
            }
            case 21: {
                return "";
            }
            case 18: {
                return "true";
            }
            case 22: {
                return "150";
            }
            case 23: {
                return "";
            }
            case 24: {
                return "true";
            }
            case 25: {
                return "";
            }
        }
        System.out.println("Preferences: Error determing standard-value: " + key);
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _hasChangedSinceLastSave = false;
    }
}

