/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.auxiliary;

public class RankParser {
    public static String getRank(int parsed) {
        if (parsed < 0) {
            return parsed * -1 + " kyu";
        }
        return parsed + " dan";
    }

    public static int parse(String rank) {
        if ((rank = rank.toLowerCase().trim()).length() <= 0) {
            return Integer.MAX_VALUE;
        }
        boolean startsLetter = !Character.isDigit(rank.charAt(0));
        boolean title = rank.startsWith("honinbo") || rank.startsWith("meijin") || rank.startsWith("tengen");
        boolean startsNR = rank.startsWith("nr");
        if (title) {
            return 30;
        }
        if (startsLetter) {
            rank = RankParser.getJustRank(rank);
        }
        if (startsNR) {
            return -40;
        }
        int iod = rank.indexOf("d");
        int iok = rank.indexOf("k");
        int iop = rank.indexOf("p");
        boolean isKyu = !(iok <= 0 || iok >= iop && iop >= 0 || iok >= iod && iod >= 0);
        boolean isDan = !(iod <= 0 || iod >= iok && iok >= 0 || iod >= iop && iop >= 0);
        boolean isPro = !(iop <= 0 || iop >= iok && iok >= 0 || iop >= iod && iod >= 0);
        char[] c = rank.toCharArray();
        int i = 0;
        while (i < c.length && Character.isDigit(c[i])) {
            ++i;
        }
        String r = rank.substring(0, i).trim();
        int rank_number = 0;
        try {
            rank_number = Integer.parseInt(r);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int fact = 1;
        if (!isDan && !isPro) {
            fact = -1;
        }
        return rank_number * fact;
    }

    protected static String getJustRank(String rank) {
        int ip;
        int ik;
        int id = rank.indexOf("d");
        int min = RankParser.getMinNotNeg(id, ik = rank.indexOf("k"), ip = rank.indexOf("p"));
        if (min >= 0) {
            char[] r1 = rank.toCharArray();
            int i = 0;
            while (i < r1.length && !Character.isDigit(r1[i])) {
                ++i;
            }
            String r2 = new String(r1).substring(i).trim();
            return r2;
        }
        return new String();
    }

    protected static int getMinNotNeg(int n1, int n2, int n3) {
        if (n1 < 0 && n2 < 0 && n3 < 0) {
            return -1;
        }
        if (n1 < 0) {
            return RankParser.getMin(n2, n3);
        }
        if (n2 < 0) {
            return RankParser.getMin(n1, n3);
        }
        if (n3 < 0) {
            return RankParser.getMin(n1, n2);
        }
        return RankParser.getMin(RankParser.getMin(n1, n2), n3);
    }

    protected static int getMin(int n1, int n2) {
        if (n1 < 0 && n2 < 0) {
            return -1;
        }
        if (n1 < 0) {
            return n2;
        }
        if (n2 < 0) {
            return n1;
        }
        if (n1 < n2) {
            return n1;
        }
        return n2;
    }

    protected static void deb(String m) {
        System.out.println(m);
    }
}

