/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.sgffilereader;

import de.gungfu.jacoto.logic.sgffilereader.SGFfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class SGFFileReader {
    protected String _database;
    protected String _targetDir;
    protected Vector _files;
    protected final int COLLECTION_MINIMUM_SIZE = 5120;
    protected final int CHARS_TO_READ = 1250;
    protected boolean useCollections;

    public SGFFileReader(String database, boolean use) {
        this.useCollections = use;
        this.setDatabase(database);
        this.startProcessing();
    }

    protected void startProcessing() {
        FileInputStream br = null;
        boolean isCollection = false;
        File file = new File(this._database);
        isCollection = file.length() > 5120L;
        this._files = new Vector();
        if (!this.useCollections || !isCollection) {
            byte[] buffer = new byte[1250];
            try {
                br = new FileInputStream(file);
                br.read(buffer);
            }
            catch (IOException e) {
                SGFFileReader.deb("Error opening SGF-record \"" + this._database + "\".\n\tMaybe file does not exist!?");
            }
            this._files.add(new SGFfile(new String(buffer)));
        } else {
            byte[] buffer = new byte[(int)file.length()];
            try {
                br = new FileInputStream(file);
                br.read(buffer);
            }
            catch (IOException e) {
                SGFFileReader.deb("Error opening SGF-record \"" + this._database + "\".\n\tMaybe file does not exist!?");
            }
            int index = 0;
            while (index < buffer.length) {
                if (buffer[index] == 40 && (buffer[index + 1] == 59 || buffer[index + 1 + System.getProperty("line.separator").length()] == 59)) {
                    String contained = this.getFileContent(buffer, index);
                    String contentString = this.cutOffDirt(contained);
                    this._files.add(new SGFfile(contentString));
                    index += contained.length();
                    continue;
                }
                ++index;
            }
        }
        try {
            br.close();
        }
        catch (Exception e) {
            SGFFileReader.deb("Error closing SGF-record \"" + this._database + "\".");
        }
        if (this._files.size() > 1) {
            SGFFileReader.deb(this._database + " is a Collection.");
            this.markFilenameAsCollection(this._files, this._database);
        } else if (this._files.size() == 1) {
            ((SGFfile)this._files.elementAt(0)).setFilename(this._database);
        } else {
            SGFFileReader.deb("No SGF-information contained in file \"" + this._database + "\".");
        }
    }

    protected void markFilenameAsCollection(Vector files, String filename) {
        filename = "Collection:" + filename;
        int i = 0;
        while (i < files.size()) {
            ((SGFfile)files.elementAt(i)).setFilename(filename + i);
            ++i;
        }
    }

    public int size() {
        return this._files.size();
    }

    public static String read(String collection, int index) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(collection));
        }
        catch (IOException e) {
            SGFFileReader.deb("Error opening database.");
        }
        String temp = null;
        StringBuffer content = new StringBuffer();
        try {
            int counter = 0;
            while (counter <= index) {
                temp = br.readLine();
                if (temp.startsWith("(;")) {
                    ++counter;
                    continue;
                }
                if (!temp.equals("(") || !(temp = br.readLine()).equals(";")) continue;
                ++counter;
            }
            content.append(temp);
            temp = br.readLine();
            while (!temp.startsWith("(;")) {
                content.append(temp);
                temp = br.readLine();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            br.close();
        }
        catch (IOException e) {
            SGFFileReader.deb("Error closing database in SGFFileReader.read().");
        }
        return content.toString();
    }

    public String getFilename(int i) {
        return ((SGFfile)this._files.elementAt(i)).getFilename();
    }

    public String getContent(int i) {
        return ((SGFfile)this._files.elementAt(i)).getContent();
    }

    protected String getFileContent(byte[] buffer, int index) {
        int at = index + 1;
        boolean done = false;
        while (at < buffer.length && at - index < 1250 && !done) {
            if (buffer[at] == 40 && (buffer[at + 1] == 59 || buffer[at + 2] == 59)) {
                done = true;
                at -= 5;
                continue;
            }
            ++at;
        }
        int size = at - index;
        byte[] buffer_help = new byte[size];
        int i = 0;
        while (i < size) {
            buffer_help[i] = buffer[index + i];
            ++i;
        }
        return new String(buffer_help);
    }

    protected String cutOffDirt(String content) {
        int indexFrom = content.indexOf("From");
        int indexSubj = content.indexOf("Subject: ");
        int index = content.length() - 1;
        if (indexFrom < 0 && indexSubj < 0) {
            return content;
        }
        if (indexFrom < indexSubj && indexFrom >= 0) {
            index = indexFrom;
        } else if (indexSubj < indexFrom && indexSubj >= 0) {
            index = indexSubj;
        }
        return content.substring(0, index);
    }

    protected void setDatabase(String base) {
        this._database = base;
    }

    protected static void deb(String m) {
        System.out.println(m);
    }
}

