/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.sorter;

import de.gungfu.jacoto.logic.FileInfo;
import de.gungfu.jacoto.logic.sorter.AbstractSorter;

class FileNameSorter
extends AbstractSorter {
    FileNameSorter() {
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1 * this._direction;
        }
        if (o2 == null) {
            return -1 * this._direction;
        }
        String s1 = ((FileInfo)o1).getFileName().toLowerCase();
        String s2 = ((FileInfo)o2).getFileName().toLowerCase();
        boolean b1 = Character.isDigit(s1.charAt(0));
        boolean b2 = Character.isDigit(s2.charAt(0));
        if (b1 && b2) {
            int i1 = 0;
            int i2 = 0;
            while (Character.isDigit(s1.charAt(i1))) {
                ++i1;
            }
            while (Character.isDigit(s2.charAt(i2))) {
                ++i2;
            }
            boolean failure = false;
            int ii1 = 0;
            int ii2 = 0;
            try {
                ii1 = Integer.parseInt(s1.substring(0, i1));
                ii2 = Integer.parseInt(s2.substring(0, i2));
            }
            catch (NumberFormatException e) {
                failure = true;
            }
            if (!failure) {
                return (ii1 - ii2) * this._direction;
            }
        } else {
            if (b1) {
                return -1 * this._direction;
            }
            if (b2) {
                return 1 * this._direction;
            }
        }
        return s1.compareTo(s2) * this._direction;
    }
}

