/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.sorter;

import de.gungfu.jacoto.logic.FileInfo;
import de.gungfu.jacoto.logic.sorter.RankSorter;

class RankBlackSorter
extends RankSorter {
    RankBlackSorter() {
    }

    public int compare(Object o1, Object o2) {
        boolean isPro2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1 * this._direction;
        }
        if (o2 == null) {
            return -1 * this._direction;
        }
        String so1 = ((FileInfo)o1).getRankBlack().toLowerCase();
        String so2 = ((FileInfo)o2).getRankBlack().toLowerCase();
        so1 = so1.trim();
        so2 = so2.trim();
        if (so1.length() <= 0 && so2.length() <= 0) {
            return 0;
        }
        if (so1.length() <= 0) {
            return 1 * this._direction;
        }
        if (so2.length() <= 0) {
            return -1 * this._direction;
        }
        boolean startsLetter1 = !Character.isDigit(so1.charAt(0));
        boolean startsLetter2 = !Character.isDigit(so2.charAt(0));
        boolean title1 = so1.startsWith("honinbo") || so1.startsWith("meijin") || so1.startsWith("tengen");
        boolean title2 = so2.startsWith("honinbo") || so2.startsWith("meijin") || so2.startsWith("tengen");
        boolean startsNR1 = so1.startsWith("nr");
        boolean startsNR2 = so2.startsWith("nr");
        if (title1 && title2) {
            return 0;
        }
        if (title1) {
            return -1 * this._direction;
        }
        if (title2) {
            return 1 * this._direction;
        }
        if (startsLetter1 && startsLetter2) {
            so1 = this.getJustRank(so1);
            so2 = this.getJustRank(so2);
        } else if (startsLetter1) {
            so1 = this.getJustRank(so1);
        } else if (startsLetter2) {
            so2 = this.getJustRank(so2);
        }
        if (startsNR1 && startsNR2) {
            return 0;
        }
        if (startsNR1 && so2.length() == 0) {
            return -1 * this._direction;
        }
        if (startsNR2 && so1.length() == 0) {
            return 1 * this._direction;
        }
        if (startsNR1) {
            return 1 * this._direction;
        }
        if (startsNR2) {
            return -1 * this._direction;
        }
        if (so1.length() == 0 && so2.length() == 0) {
            return 0;
        }
        if (so1.length() == 0) {
            return 1 * this._direction;
        }
        if (so2.length() == 0) {
            return -1 * this._direction;
        }
        int io1d = so1.indexOf("d");
        int io2d = so2.indexOf("d");
        int io1k = so1.indexOf("k");
        int io2k = so2.indexOf("k");
        int io1p = so1.indexOf("p");
        int io2p = so2.indexOf("p");
        boolean isKyu1 = !(io1k <= 0 || io1k >= io1p && io1p >= 0 || io1k >= io1d && io1d >= 0);
        boolean isKyu2 = !(io2k <= 0 || io2k >= io2p && io2p >= 0 || io2k >= io2d && io2d >= 0);
        boolean isDan1 = !(io1d <= 0 || io1d >= io1k && io1k >= 0 || io1d >= io1p && io1p >= 0);
        boolean isDan2 = !(io2d <= 0 || io2d >= io2k && io2k >= 0 || io2d >= io2p && io2p >= 0);
        boolean isPro1 = !(io1p <= 0 || io1p >= io1k && io1k >= 0 || io1p >= io1d && io1d >= 0);
        boolean bl = isPro2 = !(io2p <= 0 || io2p >= io2k && io2k >= 0 || io2p >= io2d && io2d >= 0);
        if (!(isKyu1 && isKyu2 || isDan1 && isDan2 || isPro1 && isPro2)) {
            if (isPro1) {
                return -1 * this._direction;
            }
            if (isPro2) {
                return 1 * this._direction;
            }
            if (isDan1) {
                return -1 * this._direction;
            }
            if (isDan2) {
                return 1 * this._direction;
            }
        }
        char[] c1 = so1.toCharArray();
        char[] c2 = so2.toCharArray();
        int i1 = 0;
        while (i1 < c1.length && Character.isDigit(c1[i1])) {
            ++i1;
        }
        int i2 = 0;
        while (i2 < c2.length && Character.isDigit(c2[i2])) {
            ++i2;
        }
        String r1 = so1.substring(0, i1).trim();
        String r2 = so2.substring(0, i2).trim();
        int rank1 = 0;
        int rank2 = 0;
        try {
            rank1 = Integer.parseInt(r1);
            rank2 = Integer.parseInt(r2);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int fact = 1;
        if (!isDan1 && !isPro1) {
            fact = -1;
        }
        if (rank1 < rank2) {
            return 1 * fact * this._direction;
        }
        if (rank1 > rank2) {
            return -1 * fact * this._direction;
        }
        return 0;
    }
}

