/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.statistics;

import de.gungfu.jacoto.logic.FileInfo;
import de.gungfu.jacoto.logic.FileInfoTableModel;
import de.gungfu.jacoto.logic.statistics.StatisticsSorter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class Statistics {
    protected int won;
    protected int lost;
    protected int jigo;
    protected String name;

    public Statistics() {
        this.won = 0;
        this.lost = 0;
        this.jigo = 0;
        this.name = new String();
    }

    public Statistics(int won, int lost, int jigo) {
        this.won = won;
        this.lost = lost;
        this.jigo = jigo;
        this.name = new String();
    }

    public Statistics(int won, int lost, int jigo, String name) {
        this(won, lost, jigo);
        this.name = name;
    }

    public static Vector getSinglePlayerByColor(FileInfoTableModel fit, String name) {
        Statistics forBlack = new Statistics(0, 0, 0, "playing black");
        Statistics forWhite = new Statistics(0, 0, 0, "playing white");
        int i = 0;
        while (i < fit.getSize()) {
            int res = Statistics.getWhoWon(fit.getFI(i));
            if (fit.getFI(i).getNameWhite().toLowerCase().equals(name)) {
                switch (res) {
                    case -1: {
                        forWhite.incWon();
                        break;
                    }
                    case 1: {
                        forWhite.incLost();
                        break;
                    }
                    case 0: {
                        forWhite.incJigo();
                    }
                }
            } else if (fit.getFI(i).getNameBlack().toLowerCase().equals(name)) {
                switch (res) {
                    case -1: {
                        forBlack.incLost();
                        break;
                    }
                    case 1: {
                        forBlack.incWon();
                        break;
                    }
                    case 0: {
                        forBlack.incJigo();
                    }
                }
            }
            ++i;
        }
        Vector<Statistics> result = new Vector<Statistics>();
        result.add(forBlack);
        result.add(forWhite);
        return result;
    }

    public static Statistics getSinglePlayer(FileInfoTableModel fit, String name) {
        Statistics playerStat = new Statistics(0, 0, 0, name);
        int i = 0;
        while (i < fit.getSize()) {
            int res = Statistics.getWhoWon(fit.getFI(i));
            if (fit.getFI(i).getNameBlack().equals(name)) {
                switch (res) {
                    case -1: {
                        playerStat.incLost();
                        break;
                    }
                    case 1: {
                        playerStat.incWon();
                        break;
                    }
                    case 0: {
                        playerStat.incJigo();
                    }
                }
            } else if (fit.getFI(i).getNameWhite().equals(name)) {
                switch (res) {
                    case -1: {
                        playerStat.incWon();
                        break;
                    }
                    case 1: {
                        playerStat.incLost();
                        break;
                    }
                    case 0: {
                        playerStat.incJigo();
                    }
                }
            }
            ++i;
        }
        return playerStat;
    }

    public static Statistics getAllPlayerByColor(FileInfoTableModel fit, String who) {
        int WinBlack = 0;
        int LoseBlack = 0;
        int Jigo = 0;
        boolean isBlack = who.equals("black");
        int i = 0;
        while (i < fit.getSize()) {
            String result = fit.getFI(i).getResult();
            if (result.startsWith("B")) {
                if (isBlack) {
                    ++WinBlack;
                } else {
                    ++LoseBlack;
                }
            } else if (result.startsWith("W")) {
                if (isBlack) {
                    ++LoseBlack;
                } else {
                    ++WinBlack;
                }
            } else {
                ++Jigo;
            }
            ++i;
        }
        return new Statistics(WinBlack, LoseBlack, Jigo);
    }

    public static Vector getBestPlayer(FileInfoTableModel fit) {
        Statistics[] player = Statistics.getPlayerRanking(fit);
        Vector<Statistics> result = new Vector<Statistics>();
        double bestRatio = player[0].getRatio();
        int i = 0;
        while (player[i].getRatio() == bestRatio) {
            result.add(player[i]);
            ++i;
        }
        return result;
    }

    public static Statistics[] getPlayerRanking(FileInfoTableModel fit) {
        TreeMap tm = Statistics.getStatistics(fit);
        Statistics[] sArray = Statistics.sortStatistics(tm);
        return sArray;
    }

    public static Vector getAllPlayerRanking(FileInfoTableModel fit) {
        Statistics[] stat = Statistics.getPlayerRanking(fit);
        Vector<Statistics> result = new Vector<Statistics>();
        int i = 0;
        while (i < stat.length) {
            result.add(stat[i]);
            ++i;
        }
        return result;
    }

    public static Vector getBestPlayerRanking(FileInfoTableModel fit) {
        return Statistics.get10Best(Statistics.getPlayerRanking(fit));
    }

    public static Vector getMostCommonResults(FileInfoTableModel fit) {
        Hashtable<String, Statistics> hash = new Hashtable<String, Statistics>();
        int i = 0;
        while (i < fit.getSize()) {
            String res = Statistics.getResultWithoutColor(fit.getFI(i));
            if (res != null) {
                if (res.startsWith("r")) {
                    res = "resign";
                }
                if (hash.containsKey(res)) {
                    int val = ((Statistics)hash.get(res)).getWon();
                    hash.remove(res);
                    hash.put(res, new Statistics(val + 1, 0, 0, res));
                } else {
                    hash.put(res, new Statistics(1, 0, 0, res));
                }
            }
            ++i;
        }
        Statistics[] sArray = Statistics.sortStatistics(hash);
        return Statistics.get10Best(sArray);
    }

    public static Statistics[] sortStatistics(Map tm) {
        Statistics[] sArray = tm.values().toArray(new Statistics[1]);
        Arrays.sort(sArray, new StatisticsSorter());
        return sArray;
    }

    public static TreeMap getStatistics(FileInfoTableModel fit) {
        TreeMap<String, Statistics> tm = new TreeMap<String, Statistics>();
        int i = 0;
        while (i < fit.getSize()) {
            String nameBlack = fit.getFI(i).getNameBlack();
            String nameWhite = fit.getFI(i).getNameWhite();
            Statistics statBlack = (Statistics)tm.get(nameBlack);
            Statistics statWhite = (Statistics)tm.get(nameWhite);
            boolean blackWon = fit.getFI(i).getResult().toLowerCase().trim().startsWith("b");
            boolean whiteWon = fit.getFI(i).getResult().toLowerCase().trim().startsWith("w");
            if (statBlack == null) {
                if (blackWon) {
                    tm.put(nameBlack, new Statistics(1, 0, 0, nameBlack));
                } else if (whiteWon) {
                    tm.put(nameBlack, new Statistics(0, 1, 0, nameBlack));
                } else {
                    tm.put(nameBlack, new Statistics(0, 0, 1, nameBlack));
                }
            } else if (blackWon) {
                tm.put(nameBlack, new Statistics(statBlack.getWon() + 1, statBlack.getLost(), statBlack.getJigo(), nameBlack));
            } else if (whiteWon) {
                tm.put(nameBlack, new Statistics(statBlack.getWon(), statBlack.getLost() + 1, statBlack.getJigo(), nameBlack));
            } else {
                tm.put(nameBlack, new Statistics(statBlack.getWon(), statBlack.getLost(), statBlack.getJigo() + 1, nameBlack));
            }
            if (statWhite == null) {
                if (whiteWon) {
                    tm.put(nameWhite, new Statistics(1, 0, 0, nameWhite));
                } else if (blackWon) {
                    tm.put(nameWhite, new Statistics(0, 1, 0, nameWhite));
                } else {
                    tm.put(nameWhite, new Statistics(0, 0, 1, nameWhite));
                }
            } else if (whiteWon) {
                tm.put(nameWhite, new Statistics(statWhite.getWon() + 1, statWhite.getLost(), statWhite.getJigo(), nameWhite));
            } else if (blackWon) {
                tm.put(nameWhite, new Statistics(statWhite.getWon(), statWhite.getLost() + 1, statWhite.getJigo(), nameWhite));
            } else {
                tm.put(nameWhite, new Statistics(statWhite.getWon(), statWhite.getLost(), statWhite.getJigo() + 1, nameWhite));
            }
            ++i;
        }
        return tm;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWon() {
        return this.won;
    }

    public int getLost() {
        return this.lost;
    }

    public int getJigo() {
        return this.jigo;
    }

    public String getName() {
        return this.name;
    }

    public double getRatio() {
        return this.won - this.lost;
    }

    public int getTotal() {
        return this.won + this.lost + this.jigo;
    }

    public void incWon() {
        ++this.won;
    }

    public void incLost() {
        ++this.lost;
    }

    public void incJigo() {
        ++this.jigo;
    }

    protected static int getWhoWon(FileInfo f) {
        String res = f.getResult().toUpperCase();
        if (res.startsWith("B")) {
            return 1;
        }
        if (res.startsWith("W")) {
            return -1;
        }
        return 0;
    }

    protected static String getResultWithoutColor(FileInfo f) {
        String res = f.getResult().toLowerCase().trim();
        int index = res.indexOf("+");
        if (index < 0) {
            return null;
        }
        return res.substring(index + 1).trim();
    }

    protected static Vector get10Best(Statistics[] sArray) {
        Vector<Statistics> ranking = new Vector<Statistics>();
        int i = 0;
        while (i < 10 && i < sArray.length) {
            ranking.add(sArray[i]);
            ++i;
        }
        return ranking;
    }

    protected static void deb(String s) {
        System.out.println(s);
    }
}

