/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.xml;

import de.gungfu.jacoto.logic.FileInfoTableModel;
import de.gungfu.jacoto.logic.sgffilereader.SGFFileReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class JacotoXMLReader {
    protected FileInfoTableModel _usedTable = new FileInfoTableModel();
    protected int elementID = -1;
    protected static final int JACOTO_TABLE_ELEMENT = 0;
    protected static final int TITLE_ELEMENT = 1;
    protected static final int LAST_DIR_ELEMENT = 2;
    protected static final int FILE_LOCATION_ELEMENT = 3;
    protected static final int COMMENT_ELEMENT = 4;
    protected boolean viewed = false;
    protected String shownInfoAttr = new String();
    protected String sortFieldAttr = new String();
    protected String sortDirectionAttr = new String();
    protected String locationStr;
    protected String commentStr;
    protected String titleStr;
    protected String lastDirStr;

    public void readAndBuildFIT(String filename) {
        try {
            File file = new File(filename);
            FileReader reader = new FileReader(file);
            char[] buffer = new char[(int)file.length()];
            reader.read(buffer);
            this.parse(buffer);
        }
        catch (IOException e) {
            this.deb("JacotoXMLReader.readAndBuildFIT(): IOException occurred with file \"" + filename + "\": \n" + e.getMessage());
            this._usedTable = null;
        }
    }

    public void parse(char[] buffer) {
        int Index = 0;
        try {
            while (true) {
                boolean inEndTag = false;
                boolean empty = false;
                int start = 0;
                while (buffer[Index++] != '<') {
                }
                if (buffer[Index] == '/') {
                    inEndTag = true;
                    ++Index;
                }
                start = Index;
                int counter = 0;
                while (buffer[Index++] != '>') {
                    ++counter;
                }
                String name = new String(buffer, start, counter);
                if (name.charAt(name.length() - 1) == '/') {
                    empty = true;
                    this.startElement(name.substring(0, name.length() - 1));
                } else if (inEndTag) {
                    this.endElement(name);
                } else {
                    this.startElement(name);
                }
                if (empty) continue;
                start = Index;
                int count = 0;
                while (buffer[Index++] != '<') {
                    ++count;
                }
                this.characters(new String(buffer, start, count));
                Index -= 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
    }

    public FileInfoTableModel getFIT() {
        return this._usedTable;
    }

    public String getShownInfo() {
        return this.shownInfoAttr;
    }

    public String getSortField() {
        return this.sortFieldAttr;
    }

    public int getSortDirection() {
        int retVal = 0;
        if (this.sortDirectionAttr != null) {
            try {
                retVal = Integer.valueOf(this.sortDirectionAttr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public void startElement(String eName) {
        if (eName.startsWith("JacotoTable")) {
            this.shownInfoAttr = this.getAttribute(eName, "shownInfo");
            this.shownInfoAttr = this.getAttribute(eName, "sortField");
            this.sortDirectionAttr = this.getAttribute(eName, "sortDirection");
        } else if (eName.equals("fileLocation")) {
            this.elementID = 3;
        } else if (eName.equals("comment")) {
            this.elementID = 4;
        } else if (eName.equals("viewed")) {
            this.viewed = true;
        } else if (eName.equals("title")) {
            this.elementID = 1;
        } else if (eName.equals("lastDirectory")) {
            this.elementID = 2;
        }
    }

    public void endElement(String eName) {
        if (eName.equals("FileInfo")) {
            SGFFileReader sRe = new SGFFileReader(this.locationStr, false);
            this._usedTable.addAt(this._usedTable.getSize(), FileInfoTableModel.createFileInfo(sRe.getFilename(0), sRe.getContent(0), this.commentStr, this.viewed));
            this.viewed = false;
            this.locationStr = null;
            this.commentStr = null;
        }
        this.elementID = -1;
    }

    public void characters(String s) {
        switch (this.elementID) {
            case 3: {
                if (this.locationStr != null) break;
                this.locationStr = s;
                break;
            }
            case 4: {
                if (this.commentStr != null) break;
                this.commentStr = s;
                break;
            }
            case 1: {
                if (this.titleStr != null) break;
                this.titleStr = s;
                break;
            }
            case 2: {
                if (this.lastDirStr != null) break;
                this.lastDirStr = s;
                break;
            }
        }
    }

    private String getAttribute(String attributeList, String attribute) {
        int start = attributeList.indexOf(attribute);
        if (start >= 0) {
            try {
                start = attributeList.indexOf("\"", start);
                int stop = attributeList.indexOf("\"", ++start);
                return attributeList.substring(start, stop);
            }
            catch (Exception e) {
                return new String();
            }
        }
        this.deb("Attribute \"" + attribute + "\" was not found in " + attributeList);
        return new String();
    }

    protected void deb(String s) {
        System.out.println(s);
    }

    protected void deb(char c) {
        System.out.println(c);
    }
}

