/*
 * Decompiled with CFR 0.152.
 */
package de.gungfu.jacoto.logic.xml;

import de.gungfu.jacoto.logic.FileInfo;
import de.gungfu.jacoto.logic.FileInfoTableModel;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class JacotoXMLWriter {
    protected FileInfoTableModel usedTable;

    public JacotoXMLWriter(FileInfoTableModel fit) {
        this.usedTable = fit;
    }

    public boolean write(String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write("<?xml version='1.0' encoding='utf-8' standalone='yes' ?>");
            writer.newLine();
            writer.newLine();
            writer.write("<JacotoTable shownInfo=" + this.getShownInfoAttr() + " sortField=" + this.getSortFieldAttr() + " sortDirection=" + this.getSortDirectionAttr() + " >\n\n");
            writer.write("\t<title>");
            writer.write("Untitled");
            writer.write("</title>\n\n");
            writer.write("\t<lastDirectory>");
            writer.write("A Directory path");
            writer.write("</lastDirectory>\n\n");
            int i = 0;
            while (i < this.usedTable.getSize()) {
                FileInfo fi = this.usedTable.getFI(i);
                writer.write("\t<FileInfo>\n");
                writer.write("\t   <fileLocation>" + fi.getFileLocation() + "</" + "fileLocation" + ">\n");
                String comment = fi.getComment();
                if (comment.length() > 0) {
                    writer.write("\t   <comment>" + comment + "</" + "comment" + ">\n");
                }
                if (fi.wasViewed()) {
                    writer.write("\t   <viewed/>\n");
                }
                writer.write("\t</FileInfo>\n\n");
                ++i;
            }
            writer.write("</JacotoTable>\n\n");
            writer.flush();
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getSortFieldAttr() {
        return "\"FN\"";
    }

    private String getSortDirectionAttr() {
        return "\"-1\"";
    }

    private String getShownInfoAttr() {
        return "\"FN PB BR PW WR RE COM\"";
    }
}

